/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.EntryChangeResponseControl;
import com.sun.jndi.ldap.EventSupport;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapSearchEnumeration;
import com.sun.jndi.ldap.NotifierArgs;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.PersistentSearchControl;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.io.IOException;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.HasControls;
import javax.naming.ldap.LdapName;

final class NamingEventNotifier
implements Runnable {
    private static final boolean debug = false;
    private Vector<NamingListener> namingListeners;
    private Thread worker;
    private LdapCtx context;
    private EventContext eventSrc;
    private EventSupport support;
    private NamingEnumeration<SearchResult> results;
    NotifierArgs info;

    NamingEventNotifier(EventSupport support, LdapCtx ctx, NotifierArgs info, NamingListener firstListener) throws NamingException {
        PersistentSearchControl psearch;
        this.info = info;
        this.support = support;
        try {
            psearch = new PersistentSearchControl(info.mask, true, true, true);
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Problem creating persistent search control");
            ne.setRootCause(e);
            throw ne;
        }
        this.context = (LdapCtx)ctx.newInstance(new Control[]{psearch});
        this.eventSrc = ctx;
        this.namingListeners = new Vector();
        this.namingListeners.addElement(firstListener);
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    void addNamingListener(NamingListener l) {
        this.namingListeners.addElement(l);
    }

    void removeNamingListener(NamingListener l) {
        this.namingListeners.removeElement(l);
    }

    boolean hasNamingListeners() {
        return this.namingListeners.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Continuation cont = new Continuation();
            cont.setError((Object)this, this.info.name);
            CompositeName nm = this.info.name == null || this.info.name.equals("") ? new CompositeName() : new CompositeName().add(this.info.name);
            this.results = this.context.searchAux(nm, this.info.filter, this.info.controls, true, false, cont);
            ((LdapSearchEnumeration)this.results).setStartName(this.context.currentParsedDN);
            while (this.results.hasMore()) {
                int i;
                SearchResult si = this.results.next();
                Control[] respctls = si instanceof HasControls ? ((HasControls)((Object)si)).getControls() : null;
                if (respctls == null || (i = 0) >= respctls.length || !(respctls[i] instanceof EntryChangeResponseControl)) continue;
                EntryChangeResponseControl ec = (EntryChangeResponseControl)respctls[i];
                long changeNum = ec.getChangeNumber();
                switch (ec.getChangeType()) {
                    case 1: {
                        this.fireObjectAdded(si, changeNum);
                        break;
                    }
                    case 2: {
                        this.fireObjectRemoved(si, changeNum);
                        break;
                    }
                    case 4: {
                        this.fireObjectChanged(si, changeNum);
                        break;
                    }
                    case 8: {
                        this.fireObjectRenamed(si, ec.getPreviousDN(), changeNum);
                    }
                }
            }
        }
        catch (InterruptedNamingException cont) {
        }
        catch (NamingException e) {
            this.fireNamingException(e);
            this.support.removeDeadNotifier(this.info);
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    void stop() {
        if (this.worker != null) {
            this.worker.interrupt();
            this.worker = null;
        }
    }

    private void fireObjectAdded(Binding newBd, long changeID) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        NamingEvent e = new NamingEvent(this.eventSrc, 0, newBd, null, new Long(changeID));
        this.support.queueEvent(e, this.namingListeners);
    }

    private void fireObjectRemoved(Binding oldBd, long changeID) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        NamingEvent e = new NamingEvent(this.eventSrc, 1, null, oldBd, new Long(changeID));
        this.support.queueEvent(e, this.namingListeners);
    }

    private void fireObjectChanged(Binding newBd, long changeID) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        Binding oldBd = new Binding(newBd.getName(), (Object)null, newBd.isRelative());
        NamingEvent e = new NamingEvent(this.eventSrc, 3, newBd, oldBd, new Long(changeID));
        this.support.queueEvent(e, this.namingListeners);
    }

    private void fireObjectRenamed(Binding newBd, String oldDN, long changeID) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        Binding oldBd = null;
        try {
            LdapName dn = new LdapName(oldDN);
            if (dn.startsWith(this.context.currentParsedDN)) {
                String relDN = dn.getSuffix(this.context.currentParsedDN.size()).toString();
                oldBd = new Binding(relDN, (Object)null);
            }
        }
        catch (NamingException dn) {
            // empty catch block
        }
        if (oldBd == null) {
            oldBd = new Binding(oldDN, (Object)null, false);
        }
        NamingEvent e = new NamingEvent(this.eventSrc, 2, newBd, oldBd, new Long(changeID));
        this.support.queueEvent(e, this.namingListeners);
    }

    private void fireNamingException(NamingException e) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        NamingExceptionEvent evt = new NamingExceptionEvent(this.eventSrc, e);
        this.support.queueEvent(evt, this.namingListeners);
    }
}

