/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.security;

import amazon.fws.clicommando.config.ParamConfig;

public class SecurityKeys {
    private KeyType keyType;
    private String privateKey = null;
    private String publicKey = null;
    private ParamConfig.InputMode inputMode;

    public SecurityKeys(KeyType keyType, String privateKey, String publicKey, ParamConfig.InputMode inputMode) {
        this.keyType = keyType;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.inputMode = inputMode;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public ParamConfig.InputMode getInputMode() {
        return this.inputMode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputMode == null ? 0 : this.inputMode.hashCode());
        result = 31 * result + (this.keyType == null ? 0 : this.keyType.hashCode());
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityKeys other = (SecurityKeys)obj;
        if (this.inputMode == null ? other.inputMode != null : !this.inputMode.equals((Object)other.inputMode)) {
            return false;
        }
        if (this.keyType == null ? other.keyType != null : !this.keyType.equals((Object)other.keyType)) {
            return false;
        }
        if (this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey)) {
            return false;
        }
        return !(this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Key Type: " + (this.keyType == null ? null : this.keyType.name()) + "\n");
        sb.append("Private key: " + this.privateKey + "\n");
        sb.append("Public key: " + this.publicKey + "\n");
        sb.append("Input mode: " + (this.inputMode == null ? null : this.inputMode.name()) + "\n");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyType {
        AWS_KEYS,
        CERT_PRIVATE_KEY;

    }
}

