/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.service;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.MapConfig;
import amazon.fws.clicommando.config.MapKeyConfig;
import amazon.fws.clicommando.config.MapTransConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.processors.service.AbstractScaffoldCallProcessor;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.processors.service.ServiceScaffold;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCaller;
import amazon.fws.clicommando.processors.service.aws.AwsServiceCallerFactory;
import amazon.fws.clicommando.util.AwsConventionsHelper;
import amazon.fws.clicommando.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsScaffoldCallProcessor
extends AbstractScaffoldCallProcessor
implements ServiceScaffold {
    public static final String SERVICE_URL_CONFIG_TAG = "url";
    public static final String HTTP_METHOD = "http-method";
    public static final String ACTION_CONFIG_TAG = "action";
    public static final String SIGNATURE_VERSION_CONFIG_TAG = "signature";
    public static final String SERVICE_VERSION_CONFIG_TAG = "version";
    public static final String NAMESPACE_CONFIG_TAG = "namespace";
    public static final String SOAP_VERSION_CONFIG_TAG = "soap-version";
    public static final String SERVICE_PACKAGE_CONFIG_TAG = "service-package";
    public static final String SERVICE_NAME_CONFIG_TAG = "service-name";
    public static final String CONNECTION_TIMEOUT_CONFIG_TAG = "ConnectionTimeout";
    public static final String REGION_PARAM = "Region";
    public static final String SERVICE_URL_PARAM = "ServiceUrl";
    public static final String DEFAULT_USER_AGENT = "Amazon CLI";
    public static final String DEFAULT_HTTP_METHOD = "GET";

    @Override
    public void configureScaffold(Map<String, String> config) {
        this.awsCallConfig = new ServiceCallConfig();
        if (config == null) {
            throw new ConfigurationErrorException("AwsScaffoldCallProcessor needs a config");
        }
        this.awsCallConfig.setServiceUrl(config.get(SERVICE_URL_CONFIG_TAG));
        if (config.containsKey(HTTP_METHOD)) {
            this.awsCallConfig.setHttpMethod(config.get(HTTP_METHOD));
        } else {
            this.awsCallConfig.setHttpMethod(DEFAULT_HTTP_METHOD);
        }
        this.awsCallConfig.setAction(config.get(ACTION_CONFIG_TAG));
        this.awsCallConfig.setSigVersion(config.get(SIGNATURE_VERSION_CONFIG_TAG));
        this.awsCallConfig.setServiceVersion(config.get(SERVICE_VERSION_CONFIG_TAG));
        this.awsCallConfig.setNamespace(config.get(NAMESPACE_CONFIG_TAG));
        this.awsCallConfig.setSoapVersion(config.get(SOAP_VERSION_CONFIG_TAG));
        this.awsCallConfig.setServiceName(config.get(SERVICE_NAME_CONFIG_TAG));
        this.awsCallConfig.setServicePackage(config.get(SERVICE_PACKAGE_CONFIG_TAG));
        if (StringUtils.isEmpty(this.awsCallConfig.getServiceUrl()) || StringUtils.isEmpty(this.awsCallConfig.getAction()) || StringUtils.isEmpty(this.awsCallConfig.getSigVersion())) {
            throw new ConfigurationErrorException("AwsScaffoldCallProcessor  requires url, action and signature attributes, but got: " + this.awsCallConfig);
        }
    }

    @Override
    public void processParameterMap(Command command) {
        String userAgent;
        CommandConfig commandConfig = command.getCurrentCommandConfig();
        this.awsCallConfig.setServiceUrl(this.setupUrl(this.awsCallConfig.getServiceUrl(), commandConfig));
        String sslEncryptFlag = command.getCurrentCommandConfig().getParameter("SSLEncryptionOnly").getValue();
        if (StringUtils.notEmpty(sslEncryptFlag)) {
            this.awsCallConfig.setSslEncryptionOnly(Boolean.parseBoolean(sslEncryptFlag));
        } else {
            this.awsCallConfig.setSslEncryptionOnly(false);
        }
        int timeoutSec = Integer.parseInt(commandConfig.getParameter(CONNECTION_TIMEOUT_CONFIG_TAG).getValue());
        this.awsCallConfig.setTimeout(timeoutSec);
        if (command.getVersion() == null) {
            userAgent = DEFAULT_USER_AGENT;
        } else {
            int loc;
            String version = command.getVersion().toString();
            if (version.charAt(0) == 'A' && (loc = (version = version.trim()).indexOf("Amazon")) == 0) {
                version = version.substring("Amazon".length()).trim();
            }
            userAgent = "Amazon CLI/" + version;
        }
        this.awsCallConfig.setUserAgent(userAgent);
        this.awsCallConfig.setParameters(this.buildParamMap(command));
        AwsServiceCaller serviceCaller = AwsServiceCallerFactory.getInstance(command, this.awsCallConfig);
        super.callService(serviceCaller, command);
    }

    public final ServiceCallConfig getAwsCallConfig() {
        return this.awsCallConfig;
    }

    Map<String, String> buildParamMap(Command command) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (ParamConfig param : command.getCurrentCommandConfig().getNonDirectiveParameters()) {
            if (StringUtils.notEmpty(param.getValue())) {
                ret.put(param.getName(), param.getValue());
                continue;
            }
            if (!param.getValues().isEmpty()) {
                int ordinal = 1;
                for (String value : param.getValues()) {
                    String key = param.getMapConfig().getMapTrans(MapTransConfig.MapType.KEY) == null ? (param.noXmlMember() ? param.getName() + "." + ordinal : param.getName() + ".member." + ordinal) : this.mapTrans(param, MapTransConfig.MapType.KEY, ordinal, null, null);
                    ret.put(key, value);
                    ++ordinal;
                }
                continue;
            }
            if (param.getType().equals((Object)ParamConfig.Type.MULTIPLE) && param.isSpecified().booleanValue() && param.getValues().isEmpty()) {
                ret.put(param.getName(), "");
                continue;
            }
            if (!param.getValuesMap().isEmpty()) {
                int count = 0;
                int mapCount = 0;
                int mapOrdinalStart = param.getMapConfig().getOrdinalStart();
                List<Map<String, String>> valuesMaps = param.getValuesMap();
                for (Map<String, String> valuesMap : valuesMaps) {
                    count = 0;
                    for (Map.Entry<String, String> entry : valuesMap.entrySet()) {
                        String inputKey = this.tranKey(param.getMapConfig(), entry.getKey());
                        int mapNum = mapOrdinalStart + mapCount;
                        String key = this.mapTrans(param, MapTransConfig.MapType.KEY, mapNum, count, inputKey, entry.getValue());
                        String value = this.mapTrans(param, MapTransConfig.MapType.VALUE, mapNum, count, inputKey, entry.getValue());
                        MapTransConfig mtc = param.getMapConfig().getMapTrans(MapTransConfig.MapType.KEY_VALUE);
                        if (mtc != null) {
                            key = key == null ? inputKey : key;
                            value = value == null ? entry.getValue() : value;
                            String keyValue = this.mapTrans(param, MapTransConfig.MapType.KEY_VALUE, mapNum, count, key, value);
                            ret.put(keyValue, value);
                        } else {
                            key = key.replaceAll("\\.+", "\\.");
                            int specialmap = value.indexOf("\\.\\.");
                            value = value.replaceAll("\\.+", "\\.");
                            if (entry.getValue().length() != 0 && specialmap == -1) {
                                ret.put(key, inputKey);
                                ret.put(value, entry.getValue());
                            }
                        }
                        ++count;
                    }
                    ++mapCount;
                }
                continue;
            }
            if (!param.isNullable()) continue;
            ret.put(param.getName(), "");
        }
        return ret;
    }

    private String tranKey(MapConfig mapConfig, String key) {
        MapKeyConfig mapKey = mapConfig.getKey(key);
        return mapKey == null ? key : mapKey.getTranslation();
    }

    private String mapTrans(ParamConfig param, MapTransConfig.MapType type, Integer mapId, Integer index, String key, String value) {
        if (param.getMapConfig().getMapTrans(type) == null) {
            return null;
        }
        String ret = "";
        MapTransConfig mtc = param.getMapConfig().getMapTrans(type);
        Integer position = index + mtc.getOrdinalStart();
        ret = mtc.getTranslation();
        ret = ret.replaceAll("\\{paramname\\}", param.getName());
        ret = ret.replaceAll("\\{ordinal\\}", position.toString());
        ret = ret.replaceAll("\\{key\\}", key);
        ret = ret.replaceAll("\\{value\\}", value);
        ret = ret.replaceAll("\\{map-ordinal\\}", mapId.toString());
        return ret;
    }

    private String mapTrans(ParamConfig param, MapTransConfig.MapType type, Integer index, String key, String value) {
        return this.mapTrans(param, type, 0, index, key, value);
    }

    private String setupUrl(String url, CommandConfig commandConfig) {
        String newUrl = url;
        if (newUrl != null) {
            String region = null;
            if (commandConfig.doesParameterExist(REGION_PARAM)) {
                region = commandConfig.getParameter(REGION_PARAM).getValue();
            }
            newUrl = AwsConventionsHelper.setUrlRegion(newUrl, region);
        }
        return newUrl;
    }
}

