/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.httpbinding;

import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.httpbinding.AwsHttpBindingUnexpectedResponseException;
import amazon.fws.clicommando.processors.service.ServiceResponseHandler;

public class AwsHttpBindingServiceResponseHandler
implements ServiceResponseHandler {
    private static final String DUMMY_RESPONSE_XML = "<Response/>";
    private static final int EXPECTED_RESPONSE_CODE = 200;
    private final int responseCode;
    private final String url;

    public AwsHttpBindingServiceResponseHandler(int responseCode, String url) {
        this.responseCode = responseCode;
        this.url = url;
    }

    public boolean isError() {
        return this.responseCode != 200;
    }

    public String getUrl() {
        return this.url;
    }

    public String getResponse() {
        return DUMMY_RESPONSE_XML;
    }

    public String getHeader() {
        return "";
    }

    public CliCommandoException getException() {
        return new AwsHttpBindingUnexpectedResponseException(200, this.responseCode);
    }

    public String getDebugInfo() {
        return "";
    }
}

