/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando;

import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.OutputDescriptionConfig;
import amazon.fws.clicommando.config.OutputFormatConfig;
import amazon.fws.clicommando.config.VersionInfoConfig;
import amazon.fws.clicommando.config.XsltColumnHandlerConfig;
import amazon.fws.clicommando.config.importer.ImportCommand;
import amazon.fws.clicommando.config.importer.XmlImport;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    private String[] commandLineArgs = null;
    private String command = null;
    private VersionInfoConfig version;
    private String helpPath;
    private String helpPathRoot;
    private boolean helpAdded = false;
    private ImportCommand importer;
    private boolean iterate;
    private Long iterationDelay;
    private Map<String, Object> userData;
    Map<String, CommandConfig> commandConfigs = new HashMap<String, CommandConfig>();
    Map<String, String> commandAliases = new HashMap<String, String>();
    Map<String, OutputDescriptionConfig> outputDescriptions = new HashMap<String, OutputDescriptionConfig>();
    Map<String, XsltColumnHandlerConfig> xsltColumnHandlers = new HashMap<String, XsltColumnHandlerConfig>();
    Properties properties;

    public Command() {
        this.setProperties(new Properties());
        this.iterate = false;
        this.userData = new HashMap<String, Object>();
    }

    public void addCommandConfig(CommandConfig commandConfig) {
        if (this.commandConfigs.containsKey(commandConfig.getName())) {
            throw new ConfigurationErrorException("More than one command defined for: " + commandConfig.getName());
        }
        this.commandConfigs.put(commandConfig.getName(), commandConfig);
        this.commandAliases.put(commandConfig.getAlias(), commandConfig.getName());
    }

    public String getHelpPathRoot() {
        return this.helpPathRoot;
    }

    public void setHelpPathRoot(String helpPathRoot) {
        this.helpPathRoot = helpPathRoot;
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public void setHelpPath(String helpPath) {
        this.helpPath = helpPath;
    }

    public boolean isHelpAdded() {
        return this.helpAdded;
    }

    public ImportCommand getImporter() {
        return this.importer;
    }

    public void setImporter(ImportCommand importer) {
        this.importer = importer;
    }

    public boolean iterate() {
        return this.iterate;
    }

    public void setIterate(boolean iterate) {
        this.iterate = iterate;
    }

    public Long getIterationDelay() {
        return this.iterationDelay;
    }

    public void setIterationDelay(Long delay) {
        this.iterationDelay = delay;
    }

    public Map<String, Object> getUserData() {
        return this.userData;
    }

    public void loadHelp() {
        if (!this.helpAdded) {
            XmlImport importter = new XmlImport();
            importter.attachHelpToCommand(this, this.getHelpPathRoot(), this.getHelpPath());
            this.helpAdded = true;
        }
    }

    public Map<String, CommandConfig> getCommandConfigMap() {
        return this.commandConfigs;
    }

    public Map<String, String> getCommandAliasMap() {
        return this.commandAliases;
    }

    public Collection<CommandConfig> getCommandConfigs() {
        return this.commandConfigs.values();
    }

    public void addOutputDescription(OutputDescriptionConfig outDesc) {
        this.outputDescriptions.put(outDesc.getName(), outDesc);
    }

    public Map<String, OutputDescriptionConfig> getOutputDescriptionMap() {
        return this.outputDescriptions;
    }

    public OutputDescriptionConfig getOutputDescription(String descName) {
        if (this.outputDescriptions.containsKey(descName)) {
            return this.outputDescriptions.get(descName);
        }
        throw new ConfigurationErrorException("Can't find output description '" + descName + "'.");
    }

    public Collection<OutputDescriptionConfig> getOutputDescriptions() {
        return this.outputDescriptions.values();
    }

    public OutputDescriptionConfig getCurrentOutputDescriptionConfig() {
        OutputDescriptionConfig out = null;
        OutputFormatConfig outForm = this.getCurrentCommandConfig().getOutputConfig();
        if (outForm == null) {
            throw new ConfigurationErrorException("There isn't an output formatter defined for command " + this.getCurrentCommandConfig().getName());
        }
        out = this.getOutputDescriptionMap().get(outForm.getDescriptor());
        return out;
    }

    public Map<String, XsltColumnHandlerConfig> getXsltColumnHandlers() {
        return this.xsltColumnHandlers;
    }

    public void addColumnHandler(XsltColumnHandlerConfig handler) {
        if (this.xsltColumnHandlers.containsKey(handler.getName())) {
            throw new ConfigurationErrorException("More than one xslt handler defined for: " + handler.getName());
        }
        this.xsltColumnHandlers.put(handler.getName(), handler);
    }

    public XsltColumnHandlerConfig getColumnHandler(String handlerName) {
        if (this.xsltColumnHandlers.containsKey(handlerName)) {
            return this.xsltColumnHandlers.get(handlerName);
        }
        throw new ConfigurationErrorException("Handler " + handlerName + " doesn't exist");
    }

    public CommandConfig getCurrentCommandConfig() {
        if (StringUtils.isEmpty(this.command)) {
            throw new BadInputException(ErrorMessages.ErrorCode.NO_COMMAND_SPECIFIED, new String[0]);
        }
        return this.getCommandConfig(this.command);
    }

    public CommandConfig getCommandConfig(String commandName) {
        String actualName = commandName;
        if (this.commandAliases.containsKey(commandName)) {
            actualName = this.commandAliases.get(commandName);
        }
        if (this.commandConfigs.containsKey(actualName)) {
            return this.commandConfigs.get(actualName);
        }
        throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_COMMAND, commandName);
    }

    public VersionInfoConfig getVersion() {
        return this.version;
    }

    public void setVersion(VersionInfoConfig version) {
        if (this.version != null && version != null) {
            throw new ConfigurationErrorException("Only one versioninfo is allowed per Command");
        }
        this.version = version;
    }

    public String[] getCommandLineArgs() {
        if (this.commandLineArgs != null) {
            return (String[])this.commandLineArgs.clone();
        }
        return null;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommandLineArgs(String[] commandLineArgs) {
        this.commandLineArgs = commandLineArgs != null ? (String[])commandLineArgs.clone() : null;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        return "Command:\nCommands:\n\t" + this.commandConfigs.toString() + "\n";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.commandAliases == null ? 0 : ((Object)this.commandAliases).hashCode());
        result = 31 * result + (this.commandConfigs == null ? 0 : ((Object)this.commandConfigs).hashCode());
        result = 31 * result + Arrays.hashCode(this.commandLineArgs);
        result = 31 * result + (this.helpAdded ? 1231 : 1237);
        result = 31 * result + (this.helpPath == null ? 0 : this.helpPath.hashCode());
        result = 31 * result + (this.helpPathRoot == null ? 0 : this.helpPathRoot.hashCode());
        result = 31 * result + (this.outputDescriptions == null ? 0 : ((Object)this.outputDescriptions).hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.xsltColumnHandlers == null ? 0 : ((Object)this.xsltColumnHandlers).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        if (this.command == null ? other.command != null : !this.command.equals(other.command)) {
            return false;
        }
        if (this.commandAliases == null ? other.commandAliases != null : !((Object)this.commandAliases).equals(other.commandAliases)) {
            return false;
        }
        if (this.commandConfigs == null ? other.commandConfigs != null : !((Object)this.commandConfigs).equals(other.commandConfigs)) {
            return false;
        }
        if (!Arrays.equals(this.commandLineArgs, other.commandLineArgs)) {
            return false;
        }
        if (this.helpAdded != other.helpAdded) {
            return false;
        }
        if (this.helpPath == null ? other.helpPath != null : !this.helpPath.equals(other.helpPath)) {
            return false;
        }
        if (this.helpPathRoot == null ? other.helpPathRoot != null : !this.helpPathRoot.equals(other.helpPathRoot)) {
            return false;
        }
        if (this.outputDescriptions == null ? other.outputDescriptions != null : !((Object)this.outputDescriptions).equals(other.outputDescriptions)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.xsltColumnHandlers == null ? other.xsltColumnHandlers != null : !((Object)this.xsltColumnHandlers).equals(other.xsltColumnHandlers));
    }
}

