/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.net.www.http.HttpCapture;

public class HttpCaptureOutputStream
extends FilterOutputStream {
    private HttpCapture capture = null;

    public HttpCaptureOutputStream(OutputStream out, HttpCapture cap) {
        super(out);
        this.capture = cap;
    }

    @Override
    public void write(int b) throws IOException {
        this.capture.sent(b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] ba) throws IOException {
        for (byte b : ba) {
            this.capture.sent(b);
        }
        this.out.write(ba);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            this.capture.sent(b[i]);
        }
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.capture.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.flush();
    }
}

