/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.ntlm;

import com.sun.security.ntlm.NTLM;
import com.sun.security.ntlm.NTLMException;
import com.sun.security.ntlm.Version;
import java.util.Arrays;
import java.util.Locale;

public abstract class Server
extends NTLM {
    private final String domain;
    private final boolean allVersion;

    public Server(String version, String domain) throws NTLMException {
        super(version);
        if (domain == null) {
            throw new NTLMException(6, "domain cannot be null");
        }
        this.allVersion = version == null;
        this.domain = domain;
        this.debug("NTLM Server: (t,version) = (%s,%s)\n", new Object[]{domain, version});
    }

    public byte[] type2(byte[] type1, byte[] nonce) throws NTLMException {
        if (nonce == null) {
            throw new NTLMException(6, "nonce cannot be null");
        }
        this.debug("NTLM Server: Type 1 received\n", new Object[0]);
        if (type1 != null) {
            this.debug(type1);
        }
        NTLM.Writer p = new NTLM.Writer(2, 32);
        int flags = 590341;
        p.writeSecurityBuffer(12, this.domain, true);
        p.writeInt(20, flags);
        p.writeBytes(24, nonce);
        this.debug("NTLM Server: Type 2 created\n", new Object[0]);
        this.debug(p.getBytes());
        return p.getBytes();
    }

    public String[] verify(byte[] type3, byte[] nonce) throws NTLMException {
        byte[] ntlmresponse;
        byte[] clientNonce;
        byte[] pw2;
        byte[] nthash;
        if (type3 == null || nonce == null) {
            throw new NTLMException(6, "type1 or nonce cannot be null");
        }
        this.debug("NTLM Server: Type 3 received\n", new Object[0]);
        if (type3 != null) {
            this.debug(type3);
        }
        NTLM.Reader r = new NTLM.Reader(type3);
        String username = r.readSecurityBuffer(36, true);
        String hostname = r.readSecurityBuffer(44, true);
        String incomingDomain = r.readSecurityBuffer(28, true);
        boolean verified = false;
        char[] password = this.getPassword(incomingDomain, username);
        if (password == null) {
            throw new NTLMException(3, "Unknown user");
        }
        byte[] incomingLM = r.readSecurityBuffer(12);
        byte[] incomingNTLM = r.readSecurityBuffer(20);
        if (!verified && (this.allVersion || this.v == Version.NTLM)) {
            byte[] ntresponse;
            byte[] pw1;
            byte[] lmhash;
            byte[] lmresponse;
            if (incomingLM.length > 0 && Arrays.equals(lmresponse = this.calcResponse(lmhash = this.calcLMHash(pw1 = Server.getP1(password)), nonce), incomingLM)) {
                verified = true;
            }
            if (incomingNTLM.length > 0 && Arrays.equals(ntresponse = this.calcResponse(nthash = this.calcNTHash(pw2 = Server.getP2(password)), nonce), incomingNTLM)) {
                verified = true;
            }
            this.debug("NTLM Server: verify using NTLM: " + verified + "\n", new Object[0]);
        }
        if (!verified && (this.allVersion || this.v == Version.NTLM2)) {
            pw2 = Server.getP2(password);
            nthash = this.calcNTHash(pw2);
            ntlmresponse = this.ntlm2NTLM(nthash, clientNonce = Arrays.copyOf(incomingLM, 8), nonce);
            if (Arrays.equals(incomingNTLM, ntlmresponse)) {
                verified = true;
            }
            this.debug("NTLM Server: verify using NTLM2: " + verified + "\n", new Object[0]);
        }
        if (!verified && (this.allVersion || this.v == Version.NTLMv2)) {
            pw2 = Server.getP2(password);
            nthash = this.calcNTHash(pw2);
            if (incomingLM.length > 0) {
                clientNonce = Arrays.copyOfRange(incomingLM, 16, incomingLM.length);
                byte[] lmresponse = this.calcV2(nthash, username.toUpperCase(Locale.US) + incomingDomain, clientNonce, nonce);
                if (Arrays.equals(lmresponse, incomingLM)) {
                    verified = true;
                }
            }
            if (incomingNTLM.length > 0) {
                byte[] clientBlob = Arrays.copyOfRange(incomingNTLM, 16, incomingNTLM.length);
                ntlmresponse = this.calcV2(nthash, username.toUpperCase(Locale.US) + incomingDomain, clientBlob, nonce);
                if (Arrays.equals(ntlmresponse, incomingNTLM)) {
                    verified = true;
                }
            }
            this.debug("NTLM Server: verify using NTLMv2: " + verified + "\n", new Object[0]);
        }
        if (!verified) {
            throw new NTLMException(4, "None of LM and NTLM verified");
        }
        return new String[]{username, hostname};
    }

    public abstract char[] getPassword(String var1, String var2);
}

