/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.SecureRandom;
import sun.security.ssl.RandomCookie;

final class SessionId {
    private byte[] sessionId;

    SessionId(boolean isRejoinable, SecureRandom generator) {
        this.sessionId = isRejoinable ? new RandomCookie((SecureRandom)generator).random_bytes : new byte[0];
    }

    SessionId(byte[] sessionId) {
        this.sessionId = sessionId;
    }

    int length() {
        return this.sessionId.length;
    }

    byte[] getId() {
        return (byte[])this.sessionId.clone();
    }

    public String toString() {
        int len = this.sessionId.length;
        StringBuffer s = new StringBuffer(10 + 2 * len);
        s.append("{");
        for (int i = 0; i < len; ++i) {
            s.append(0xFF & this.sessionId[i]);
            if (i == len - 1) continue;
            s.append(", ");
        }
        s.append("}");
        return s.toString();
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 0; i < this.sessionId.length; ++i) {
            retval += this.sessionId[i];
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SessionId)) {
            return false;
        }
        SessionId s = (SessionId)obj;
        byte[] b = s.getId();
        if (b.length != this.sessionId.length) {
            return false;
        }
        for (int i = 0; i < this.sessionId.length; ++i) {
            if (b[i] == this.sessionId[i]) continue;
            return false;
        }
        return true;
    }
}

