/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.pool.Pool;

public final class PoolCleaner
extends Thread {
    private final Pool[] pools;
    private final long period;

    public PoolCleaner(long period, Pool[] pools) {
        this.period = period;
        this.pools = (Pool[])pools.clone();
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            PoolCleaner poolCleaner = this;
            synchronized (poolCleaner) {
                try {
                    this.wait(this.period);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long threshold = System.currentTimeMillis() - this.period;
                for (int i = 0; i < this.pools.length; ++i) {
                    if (this.pools[i] == null) continue;
                    this.pools[i].expire(threshold);
                }
            }
        }
    }
}

