/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RowFilter<M, I> {
    private static void checkIndices(int[] columns) {
        for (int i = columns.length - 1; i >= 0; --i) {
            if (columns[i] >= 0) continue;
            throw new IllegalArgumentException("Index must be >= 0");
        }
    }

    public static <M, I> RowFilter<M, I> regexFilter(String regex, int ... indices) {
        return new RegexFilter(Pattern.compile(regex), indices);
    }

    public static <M, I> RowFilter<M, I> dateFilter(ComparisonType type, Date date, int ... indices) {
        return new DateFilter(type, date.getTime(), indices);
    }

    public static <M, I> RowFilter<M, I> numberFilter(ComparisonType type, Number number, int ... indices) {
        return new NumberFilter(type, number, indices);
    }

    public static <M, I> RowFilter<M, I> orFilter(Iterable<? extends RowFilter<? super M, ? super I>> filters) {
        return new OrFilter(filters);
    }

    public static <M, I> RowFilter<M, I> andFilter(Iterable<? extends RowFilter<? super M, ? super I>> filters) {
        return new AndFilter(filters);
    }

    public static <M, I> RowFilter<M, I> notFilter(RowFilter<M, I> filter) {
        return new NotFilter<M, I>(filter);
    }

    public abstract boolean include(Entry<? extends M, ? extends I> var1);

    private static class NotFilter<M, I>
    extends RowFilter<M, I> {
        private RowFilter<M, I> filter;

        NotFilter(RowFilter<M, I> filter) {
            if (filter == null) {
                throw new IllegalArgumentException("filter must be non-null");
            }
            this.filter = filter;
        }

        @Override
        public boolean include(Entry<? extends M, ? extends I> value) {
            return !this.filter.include(value);
        }
    }

    private static class AndFilter<M, I>
    extends OrFilter<M, I> {
        AndFilter(Iterable<? extends RowFilter<? super M, ? super I>> filters) {
            super(filters);
        }

        @Override
        public boolean include(Entry<? extends M, ? extends I> value) {
            for (RowFilter filter : this.filters) {
                if (filter.include(value)) continue;
                return false;
            }
            return true;
        }
    }

    private static class OrFilter<M, I>
    extends RowFilter<M, I> {
        List<RowFilter<? super M, ? super I>> filters = new ArrayList<RowFilter<? super M, ? super I>>();

        OrFilter(Iterable<? extends RowFilter<? super M, ? super I>> filters) {
            for (RowFilter<M, I> rowFilter : filters) {
                if (rowFilter == null) {
                    throw new IllegalArgumentException("Filter must be non-null");
                }
                this.filters.add(rowFilter);
            }
        }

        @Override
        public boolean include(Entry<? extends M, ? extends I> value) {
            for (RowFilter<? extends M, ? extends I> rowFilter : this.filters) {
                if (!rowFilter.include(value)) continue;
                return true;
            }
            return false;
        }
    }

    private static class NumberFilter
    extends GeneralFilter {
        private boolean isComparable;
        private Number number;
        private ComparisonType type;

        NumberFilter(ComparisonType type, Number number, int[] columns) {
            super(columns);
            if (type == null || number == null) {
                throw new IllegalArgumentException("type and number must be non-null");
            }
            this.type = type;
            this.number = number;
            this.isComparable = number instanceof Comparable;
        }

        @Override
        protected boolean include(Entry<? extends Object, ? extends Object> value, int index) {
            Object v = value.getValue(index);
            if (v instanceof Number) {
                boolean compared = true;
                Class<?> vClass = v.getClass();
                int compareResult = this.number.getClass() == vClass && this.isComparable ? ((Comparable)((Object)this.number)).compareTo(v) : this.longCompare((Number)v);
                switch (this.type) {
                    case BEFORE: {
                        return compareResult > 0;
                    }
                    case AFTER: {
                        return compareResult < 0;
                    }
                    case EQUAL: {
                        return compareResult == 0;
                    }
                    case NOT_EQUAL: {
                        return compareResult != 0;
                    }
                }
            }
            return false;
        }

        private int longCompare(Number o) {
            long diff = this.number.longValue() - o.longValue();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class DateFilter
    extends GeneralFilter {
        private long date;
        private ComparisonType type;

        DateFilter(ComparisonType type, long date, int[] columns) {
            super(columns);
            if (type == null) {
                throw new IllegalArgumentException("type must be non-null");
            }
            this.type = type;
            this.date = date;
        }

        @Override
        protected boolean include(Entry<? extends Object, ? extends Object> value, int index) {
            Object v = value.getValue(index);
            if (v instanceof Date) {
                long vDate = ((Date)v).getTime();
                switch (this.type) {
                    case BEFORE: {
                        return vDate < this.date;
                    }
                    case AFTER: {
                        return vDate > this.date;
                    }
                    case EQUAL: {
                        return vDate == this.date;
                    }
                    case NOT_EQUAL: {
                        return vDate != this.date;
                    }
                }
            }
            return false;
        }
    }

    private static class RegexFilter
    extends GeneralFilter {
        private Matcher matcher;

        RegexFilter(Pattern regex, int[] columns) {
            super(columns);
            if (regex == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            this.matcher = regex.matcher("");
        }

        @Override
        protected boolean include(Entry<? extends Object, ? extends Object> value, int index) {
            this.matcher.reset(value.getStringValue(index));
            return this.matcher.find();
        }
    }

    private static abstract class GeneralFilter
    extends RowFilter<Object, Object> {
        private int[] columns;

        GeneralFilter(int[] columns) {
            RowFilter.checkIndices(columns);
            this.columns = columns;
        }

        @Override
        public boolean include(Entry<? extends Object, ? extends Object> value) {
            int count = value.getValueCount();
            if (this.columns.length > 0) {
                for (int i = this.columns.length - 1; i >= 0; --i) {
                    int index = this.columns[i];
                    if (index >= count || !this.include(value, index)) continue;
                    return true;
                }
            } else {
                while (--count >= 0) {
                    if (!this.include(value, count)) continue;
                    return true;
                }
            }
            return false;
        }

        protected abstract boolean include(Entry<? extends Object, ? extends Object> var1, int var2);
    }

    public static abstract class Entry<M, I> {
        public abstract M getModel();

        public abstract int getValueCount();

        public abstract Object getValue(int var1);

        public String getStringValue(int index) {
            Object value = this.getValue(index);
            return value == null ? "" : value.toString();
        }

        public abstract I getIdentifier();
    }

    public static enum ComparisonType {
        BEFORE,
        AFTER,
        EQUAL,
        NOT_EQUAL;

    }
}

