/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class ObjectView
extends ComponentView {
    public ObjectView(Element elem) {
        super(elem);
    }

    @Override
    protected Component createComponent() {
        AttributeSet attr = this.getElement().getAttributes();
        String classname = (String)attr.getAttribute(HTML.Attribute.CLASSID);
        try {
            ReflectUtil.checkPackageAccess(classname);
            Class<?> c = Class.forName(classname, true, Thread.currentThread().getContextClassLoader());
            Object o = c.newInstance();
            if (o instanceof Component) {
                Component comp = (Component)o;
                this.setParameters(comp, attr);
                return comp;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getUnloadableRepresentation();
    }

    Component getUnloadableRepresentation() {
        JLabel comp = new JLabel("??");
        ((Component)comp).setForeground(Color.red);
        return comp;
    }

    private void setParameters(Component comp, AttributeSet attr) {
        BeanInfo bi;
        Class<?> k = comp.getClass();
        try {
            bi = Introspector.getBeanInfo(k);
        }
        catch (IntrospectionException ex) {
            System.err.println("introspector failed, ex: " + ex);
            return;
        }
        PropertyDescriptor[] props = bi.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            Object v = attr.getAttribute(props[i].getName());
            if (!(v instanceof String)) continue;
            String value = (String)v;
            Method writer = props[i].getWriteMethod();
            if (writer == null) {
                return;
            }
            Class<?>[] params = writer.getParameterTypes();
            if (params.length != 1) {
                return;
            }
            Object[] args = new Object[]{value};
            try {
                MethodUtil.invoke(writer, comp, args);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Invocation failed");
            }
        }
    }
}

