/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Invokers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;

class InvokeGeneric {
    private final MethodType erasedCallerType;
    private final MethodHandle initialInvoker;
    private static final Class<?>[] EXTRA_ARGS = new Class[]{MethodType.class, MethodHandle.class};
    static final boolean USE_AS_TYPE_PATH = true;

    InvokeGeneric(MethodType erasedCallerType) throws ReflectiveOperationException {
        assert (erasedCallerType.equals((Object)erasedCallerType.erase()));
        this.erasedCallerType = erasedCallerType;
        this.initialInvoker = this.makeInitialInvoker();
        assert (this.initialInvoker.type().equals((Object)erasedCallerType.insertParameterTypes(0, MethodType.class, MethodHandle.class))) : this.initialInvoker.type();
    }

    private static MethodHandles.Lookup lookup() {
        return MethodHandles.Lookup.IMPL_LOOKUP;
    }

    static MethodHandle generalInvokerOf(MethodType erasedCallerType) throws ReflectiveOperationException {
        InvokeGeneric gen = new InvokeGeneric(erasedCallerType);
        return gen.initialInvoker;
    }

    private MethodHandle makeInitialInvoker() throws ReflectiveOperationException {
        MethodHandle postDispatch = this.makePostDispatchInvoker();
        MethodHandle invoker = this.returnConversionPossible() ? MethodHandles.foldArguments(postDispatch, this.dispatcher("dispatchWithConversion")) : MethodHandles.foldArguments(postDispatch, this.dispatcher("dispatch"));
        return invoker;
    }

    private MethodHandle makePostDispatchInvoker() {
        MethodType invokerType = this.erasedCallerType.insertParameterTypes(0, EXTRA_ARGS);
        return invokerType.invokers().exactInvoker();
    }

    private MethodHandle dropDispatchArguments(MethodHandle targetInvoker) {
        assert (targetInvoker.type().parameterType(0) == MethodHandle.class);
        return MethodHandles.dropArguments(targetInvoker, 1, EXTRA_ARGS);
    }

    private MethodHandle dispatcher(String dispatchName) throws ReflectiveOperationException {
        return InvokeGeneric.lookup().bind(this, dispatchName, MethodType.methodType(MethodHandle.class, MethodType.class, MethodHandle.class));
    }

    private MethodHandle dispatch(MethodType callerType, MethodHandle target) {
        MethodType targetType = target.type();
        MethodHandle newTarget = target.asType(callerType);
        targetType = callerType;
        Invokers invokers = targetType.invokers();
        MethodHandle invoker = invokers.erasedInvokerWithDrops;
        if (invoker == null) {
            invokers.erasedInvokerWithDrops = invoker = this.dropDispatchArguments(invokers.erasedInvoker());
        }
        return invoker.bindTo(newTarget);
    }

    private MethodHandle dispatchWithConversion(MethodType callerType, MethodHandle target) {
        MethodHandle finisher = this.dispatch(callerType, target);
        if (this.returnConversionNeeded(callerType, target)) {
            finisher = this.addReturnConversion(finisher, callerType.returnType());
        }
        return finisher;
    }

    private boolean returnConversionPossible() {
        Class<?> needType = this.erasedCallerType.returnType();
        return !needType.isPrimitive();
    }

    private boolean returnConversionNeeded(MethodType callerType, MethodHandle target) {
        Class<?> needType = callerType.returnType();
        if (needType == this.erasedCallerType.returnType()) {
            return false;
        }
        Class<?> haveType = target.type().returnType();
        return !VerifyType.isNullConversion(haveType, needType) || needType.isInterface();
    }

    private MethodHandle addReturnConversion(MethodHandle finisher, Class<?> type) {
        MethodType finisherType = finisher.type();
        MethodHandle caster = ValueConversions.identity(type);
        caster = caster.asType(caster.type().changeParameterType(0, finisherType.returnType()));
        finisher = MethodHandles.filterReturnValue(finisher, caster);
        return finisher.asType(finisherType);
    }

    public String toString() {
        return "InvokeGeneric" + this.erasedCallerType;
    }
}

