/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import sun.awt.UNIXToolkit;
import sun.awt.X11.OwnershipListener;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XDataTransferer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XSelection;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;
import sun.security.action.GetIntegerAction;

public final class XClipboard
extends SunClipboard
implements OwnershipListener {
    private final XSelection selection;
    private long convertSelectionTime;
    private volatile boolean isSelectionNotifyProcessed;
    private volatile XAtom targetsPropertyAtom;
    private static final Object classLock = new Object();
    private static final int defaultPollInterval = 200;
    private static int pollInterval;
    private static Map<Long, XClipboard> targetsAtom2Clipboard;

    public XClipboard(String name, String selectionName) {
        super(name);
        this.selection = new XSelection(XAtom.get(selectionName));
        this.selection.registerOwershipListener(this);
    }

    @Override
    public void ownershipChanged(boolean isOwner) {
        if (isOwner) {
            this.checkChangeHere(this.contents);
        } else {
            this.lostOwnershipImpl();
        }
    }

    @Override
    protected synchronized void setContentsNative(Transferable contents) {
        long[] formats;
        SortedMap formatMap = DataTransferer.getInstance().getFormatsForTransferable(contents, DataTransferer.adaptFlavorMap(XClipboard.getDefaultFlavorTable()));
        if (!this.selection.setOwner(contents, formatMap, formats = DataTransferer.keysToLongArray(formatMap), XToolkit.getCurrentServerTime())) {
            this.owner = null;
            this.contents = null;
        }
    }

    @Override
    public long getID() {
        return this.selection.getSelectionAtom().getAtom();
    }

    @Override
    public synchronized Transferable getContents(Object requestor) {
        if (this.contents != null) {
            return this.contents;
        }
        return new ClipboardTransferable(this);
    }

    @Override
    protected void clearNativeContext() {
        this.selection.reset();
    }

    @Override
    protected long[] getClipboardFormats() {
        return this.selection.getTargets(XToolkit.getCurrentServerTime());
    }

    @Override
    protected byte[] getClipboardData(long format) throws IOException {
        return this.selection.getData(format, XToolkit.getCurrentServerTime());
    }

    private void checkChangeHere(Transferable contents) {
        if (this.areFlavorListenersRegistered()) {
            this.checkChange(DataTransferer.getInstance().getFormatsForTransferableAsArray(contents, XClipboard.getDefaultFlavorTable()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPollInterval() {
        Object object = classLock;
        synchronized (object) {
            if (pollInterval <= 0 && (pollInterval = AccessController.doPrivileged(new GetIntegerAction("awt.datatransfer.clipboard.poll.interval", 200)).intValue()) <= 0) {
                pollInterval = 200;
            }
            return pollInterval;
        }
    }

    private XAtom getTargetsPropertyAtom() {
        if (null == this.targetsPropertyAtom) {
            this.targetsPropertyAtom = XAtom.get("XAWT_TARGETS_OF_SELECTION:" + this.selection.getSelectionAtom().getName());
        }
        return this.targetsPropertyAtom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerClipboardViewerChecked() {
        this.isSelectionNotifyProcessed = true;
        boolean mustSchedule = false;
        Object object = classLock;
        synchronized (object) {
            if (targetsAtom2Clipboard == null) {
                targetsAtom2Clipboard = new HashMap<Long, XClipboard>(2);
            }
            mustSchedule = targetsAtom2Clipboard.isEmpty();
            targetsAtom2Clipboard.put(this.getTargetsPropertyAtom().getAtom(), this);
            if (mustSchedule) {
                XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), new SelectionNotifyHandler());
            }
        }
        if (mustSchedule) {
            XToolkit.schedule(new CheckChangeTimerTask(), XClipboard.getPollInterval());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregisterClipboardViewerChecked() {
        this.isSelectionNotifyProcessed = false;
        Object object = classLock;
        synchronized (object) {
            targetsAtom2Clipboard.remove(this.getTargetsPropertyAtom().getAtom());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTargetsDelayed() {
        XToolkit.awtLock();
        try {
            long curTime = System.currentTimeMillis();
            if (this.isSelectionNotifyProcessed || curTime >= this.convertSelectionTime + (long)UNIXToolkit.getDatatransferTimeout()) {
                this.convertSelectionTime = curTime;
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.selection.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), this.getTargetsPropertyAtom().getAtom(), XWindow.getXAWTRootWindow().getWindow(), 0L);
                this.isSelectionNotifyProcessed = false;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChange(XSelectionEvent xse) {
        long propertyAtom = xse.get_property();
        if (propertyAtom != this.getTargetsPropertyAtom().getAtom()) {
            return;
        }
        XAtom selectionAtom = XAtom.get(xse.get_selection());
        XSelection changedSelection = XSelection.getSelection(selectionAtom);
        if (null == changedSelection || changedSelection != this.selection) {
            return;
        }
        this.isSelectionNotifyProcessed = true;
        if (this.selection.isOwner()) {
            return;
        }
        long[] formats = null;
        if (propertyAtom == 0L) {
            formats = new long[]{};
        } else {
            WindowPropertyGetter targetsGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), XAtom.get(propertyAtom), 0L, 1000000L, true, 0L);
            try {
                targetsGetter.execute();
                formats = XSelection.getFormats(targetsGetter);
            }
            finally {
                targetsGetter.dispose();
            }
        }
        this.checkChange(formats);
    }

    private static class SelectionNotifyHandler
    implements XEventDispatcher {
        private SelectionNotifyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchEvent(XEvent ev) {
            if (ev.get_type() == 31) {
                XSelectionEvent xse = ev.get_xselection();
                XClipboard clipboard = null;
                Object object = classLock;
                synchronized (object) {
                    if (targetsAtom2Clipboard != null && !targetsAtom2Clipboard.isEmpty()) {
                        XToolkit.removeEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), this);
                        return;
                    }
                    long propertyAtom = xse.get_property();
                    clipboard = (XClipboard)targetsAtom2Clipboard.get(propertyAtom);
                }
                if (null != clipboard) {
                    clipboard.checkChange(xse);
                }
            }
        }
    }

    private static class CheckChangeTimerTask
    implements Runnable {
        private CheckChangeTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (XClipboard clpbrd : targetsAtom2Clipboard.values()) {
                clpbrd.getTargetsDelayed();
            }
            Object object = classLock;
            synchronized (object) {
                if (targetsAtom2Clipboard != null && !targetsAtom2Clipboard.isEmpty()) {
                    XToolkit.schedule(this, XClipboard.getPollInterval());
                }
            }
        }
    }
}

