/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VpnGatewayDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateVpnGateway
extends BaseCmd {
    private static final String TYPE_DESC = "The type of VPN connection this VPN gateway supports.";
    public static final String AVAILABILITY_ZONE_DESC = "The availability zone where you want the VPN gateway.";
    private String type;
    private String availabilityZone;

    public CreateVpnGateway(String[] args) {
        super("ec2addvgw", "ec2-create-vpn-gateway");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "--type TYPE --availability-zone ZONE";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TYPE");
        OptionBuilder.withDescription((String)this.joinDescription(TYPE_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"availability-zone");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ZONE");
        OptionBuilder.withDescription((String)this.joinDescription(AVAILABILITY_ZONE_DESC));
        options.addOption(OptionBuilder.create((String)"z"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a new VPN gateway. A VPN gateway is the VPC-side endpoint for your");
        System.out.println("     VPN connection.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("type");
        this.printOption("availability-zone");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.type = this.getOptionValue("type");
        this.availabilityZone = this.getOptionValue("availability-zone");
        RequestResultPair rsp = jec2.createVpnGateway(this.type, this.availabilityZone);
        out.output(System.out, (VpnGatewayDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertOptionSet("type");
    }

    public static void main(String[] args) {
        new CreateVpnGateway(args).invoke();
    }
}

