/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.tracing.ProbeSkeleton;
import sun.tracing.dtrace.DTraceProvider;
import sun.tracing.dtrace.JVM;

class DTraceProbe
extends ProbeSkeleton {
    private Object proxy;
    private Method declared_method;
    private Method implementing_method;

    DTraceProbe(Object proxy, Method m) {
        super(m.getParameterTypes());
        this.proxy = proxy;
        this.declared_method = m;
        try {
            this.implementing_method = proxy.getClass().getMethod(m.getName(), m.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error, wrong proxy class");
        }
    }

    @Override
    public boolean isEnabled() {
        return JVM.isEnabled(this.implementing_method);
    }

    @Override
    public void uncheckedTrigger(Object[] args) {
        block4: {
            try {
                this.implementing_method.invoke(this.proxy, args);
            }
            catch (IllegalAccessException e) {
                assert (false);
            }
            catch (InvocationTargetException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    String getProbeName() {
        return DTraceProvider.getProbeName(this.declared_method);
    }

    String getFunctionName() {
        return DTraceProvider.getFunctionName(this.declared_method);
    }

    Method getMethod() {
        return this.implementing_method;
    }

    Class<?>[] getParameterTypes() {
        return this.parameters;
    }
}

