/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoableEditSupport {
    protected int updateLevel;
    protected CompoundEdit compoundEdit;
    protected Vector<UndoableEditListener> listeners;
    protected Object realSource;

    public UndoableEditSupport() {
        this(null);
    }

    public UndoableEditSupport(Object r) {
        this.realSource = r == null ? this : r;
        this.updateLevel = 0;
        this.compoundEdit = null;
        this.listeners = new Vector();
    }

    public synchronized void addUndoableEditListener(UndoableEditListener l) {
        this.listeners.addElement(l);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener l) {
        this.listeners.removeElement(l);
    }

    public synchronized UndoableEditListener[] getUndoableEditListeners() {
        return this.listeners.toArray(new UndoableEditListener[0]);
    }

    protected void _postEdit(UndoableEdit e) {
        UndoableEditEvent ev = new UndoableEditEvent(this.realSource, e);
        Enumeration cursor = ((Vector)this.listeners.clone()).elements();
        while (cursor.hasMoreElements()) {
            ((UndoableEditListener)cursor.nextElement()).undoableEditHappened(ev);
        }
    }

    public synchronized void postEdit(UndoableEdit e) {
        if (this.updateLevel == 0) {
            this._postEdit(e);
        } else {
            this.compoundEdit.addEdit(e);
        }
    }

    public int getUpdateLevel() {
        return this.updateLevel;
    }

    public synchronized void beginUpdate() {
        if (this.updateLevel == 0) {
            this.compoundEdit = this.createCompoundEdit();
        }
        ++this.updateLevel;
    }

    protected CompoundEdit createCompoundEdit() {
        return new CompoundEdit();
    }

    public synchronized void endUpdate() {
        --this.updateLevel;
        if (this.updateLevel == 0) {
            this.compoundEdit.end();
            this._postEdit(this.compoundEdit);
            this.compoundEdit = null;
        }
    }

    public String toString() {
        return super.toString() + " updateLevel: " + this.updateLevel + " listeners: " + this.listeners + " compoundEdit: " + this.compoundEdit;
    }
}

