/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.MergeCollation;
import java.text.ParseException;
import java.text.PatternEntry;
import java.text.RBCollationTables;
import java.util.Vector;
import sun.text.ComposedCharIter;
import sun.text.IntHashtable;
import sun.text.UCompactIntArray;
import sun.text.normalizer.NormalizerImpl;

final class RBTableBuilder {
    static final int CHARINDEX = 0x70000000;
    private static final int IGNORABLEMASK = 65535;
    private static final int PRIMARYORDERINCREMENT = 65536;
    private static final int SECONDARYORDERINCREMENT = 256;
    private static final int TERTIARYORDERINCREMENT = 1;
    private static final int INITIALTABLESIZE = 20;
    private static final int MAXKEYSIZE = 5;
    private RBCollationTables.BuildAPI tables = null;
    private MergeCollation mPattern = null;
    private boolean isOverIgnore = false;
    private char[] keyBuf = new char[5];
    private IntHashtable contractFlags = new IntHashtable(100);
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private UCompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    public RBTableBuilder(RBCollationTables.BuildAPI tables) {
        this.tables = tables;
    }

    public void build(String pattern, int decmp) throws ParseException {
        boolean isSource = true;
        int i = 0;
        if (pattern.length() == 0) {
            throw new ParseException("Build rules empty.", 0);
        }
        this.mapping = new UCompactIntArray(-1);
        pattern = NormalizerImpl.canonicalDecomposeWithSingleQuotation(pattern);
        this.mPattern = new MergeCollation(pattern);
        int order = 0;
        for (i = 0; i < this.mPattern.getCount(); ++i) {
            char ch;
            PatternEntry entry = this.mPattern.getItemAt(i);
            if (entry == null) continue;
            String groupChars = entry.getChars();
            if (groupChars.length() > 1) {
                switch (groupChars.charAt(groupChars.length() - 1)) {
                    case '@': {
                        this.frenchSec = true;
                        groupChars = groupChars.substring(0, groupChars.length() - 1);
                        break;
                    }
                    case '!': {
                        this.seAsianSwapping = true;
                        groupChars = groupChars.substring(0, groupChars.length() - 1);
                    }
                }
            }
            order = this.increment(entry.getStrength(), order);
            String expChars = entry.getExtension();
            if (expChars.length() != 0) {
                this.addExpandOrder(groupChars, expChars, order);
                continue;
            }
            if (groupChars.length() > 1) {
                ch = groupChars.charAt(0);
                if (Character.isHighSurrogate(ch) && groupChars.length() == 2) {
                    this.addOrder(Character.toCodePoint(ch, groupChars.charAt(1)), order);
                    continue;
                }
                this.addContractOrder(groupChars, order);
                continue;
            }
            ch = groupChars.charAt(0);
            this.addOrder(ch, order);
        }
        this.addComposedChars();
        this.commit();
        this.mapping.compact();
        this.tables.fillInTables(this.frenchSec, this.seAsianSwapping, this.mapping, this.contractTable, this.expandTable, this.contractFlags, this.maxSecOrder, this.maxTerOrder);
    }

    private void addComposedChars() throws ParseException {
        int c;
        ComposedCharIter iter = new ComposedCharIter();
        while ((c = iter.next()) != -1) {
            char ch0;
            if (this.getCharOrder(c) != -1) continue;
            String s = iter.decomposition();
            if (s.length() == 1) {
                int order = this.getCharOrder(s.charAt(0));
                if (order == -1) continue;
                this.addOrder(c, order);
                continue;
            }
            if (s.length() == 2 && Character.isHighSurrogate(ch0 = s.charAt(0))) {
                int order = this.getCharOrder(s.codePointAt(0));
                if (order == -1) continue;
                this.addOrder(c, order);
                continue;
            }
            int contractOrder = this.getContractOrder(s);
            if (contractOrder != -1) {
                this.addOrder(c, contractOrder);
                continue;
            }
            boolean allThere = true;
            for (int i = 0; i < s.length(); ++i) {
                if (this.getCharOrder(s.charAt(i)) != -1) continue;
                allThere = false;
                break;
            }
            if (!allThere) continue;
            this.addExpandOrder(c, s, -1);
        }
    }

    private final void commit() {
        if (this.expandTable != null) {
            for (int i = 0; i < this.expandTable.size(); ++i) {
                int[] valueList = (int[])this.expandTable.elementAt(i);
                for (int j = 0; j < valueList.length; ++j) {
                    int order = valueList[j];
                    if (order >= 0x7E000000 || order <= 0x70000000) continue;
                    int ch = order - 0x70000000;
                    int realValue = this.getCharOrder(ch);
                    valueList[j] = realValue == -1 ? 0xFFFF & ch : realValue;
                }
            }
        }
    }

    private final int increment(int aStrength, int lastValue) {
        switch (aStrength) {
            case 0: {
                lastValue += 65536;
                lastValue &= 0xFFFF0000;
                this.isOverIgnore = true;
                break;
            }
            case 1: {
                lastValue += 256;
                lastValue &= 0xFFFFFF00;
                if (this.isOverIgnore) break;
                this.maxSecOrder = (short)(this.maxSecOrder + 1);
                break;
            }
            case 2: {
                ++lastValue;
                if (this.isOverIgnore) break;
                this.maxTerOrder = (short)(this.maxTerOrder + 1);
            }
        }
        return lastValue;
    }

    private final void addOrder(int ch, int anOrder) {
        int order = this.mapping.elementAt(ch);
        if (order >= 0x7F000000) {
            int length = 1;
            if (Character.isSupplementaryCodePoint(ch)) {
                length = Character.toChars(ch, this.keyBuf, 0);
            } else {
                this.keyBuf[0] = (char)ch;
            }
            this.addContractOrder(new String(this.keyBuf, 0, length), anOrder);
        } else {
            this.mapping.setElementAt(ch, anOrder);
        }
    }

    private final void addContractOrder(String groupChars, int anOrder) {
        this.addContractOrder(groupChars, anOrder, true);
    }

    private final void addContractOrder(String groupChars, int anOrder, boolean fwd) {
        int index;
        int ch;
        int entry;
        Vector<EntryPair> entryTable;
        if (this.contractTable == null) {
            this.contractTable = new Vector(20);
        }
        if ((entryTable = this.getContractValuesImpl((entry = this.mapping.elementAt(ch = groupChars.codePointAt(0))) - 0x7F000000)) == null) {
            int tableIndex = 0x7F000000 + this.contractTable.size();
            entryTable = new Vector<EntryPair>(20);
            this.contractTable.addElement(entryTable);
            entryTable.addElement(new EntryPair(groupChars.substring(0, Character.charCount(ch)), entry));
            this.mapping.setElementAt(ch, tableIndex);
        }
        if ((index = RBCollationTables.getEntry(entryTable, groupChars, fwd)) != -1) {
            EntryPair pair = (EntryPair)entryTable.elementAt(index);
            pair.value = anOrder;
        } else {
            EntryPair pair = (EntryPair)entryTable.lastElement();
            if (groupChars.length() > pair.entryName.length()) {
                entryTable.addElement(new EntryPair(groupChars, anOrder, fwd));
            } else {
                entryTable.insertElementAt(new EntryPair(groupChars, anOrder, fwd), entryTable.size() - 1);
            }
        }
        if (fwd && groupChars.length() > 1) {
            this.addContractFlags(groupChars);
            this.addContractOrder(new StringBuffer(groupChars).reverse().toString(), anOrder, false);
        }
    }

    private int getContractOrder(String groupChars) {
        int index;
        int ch;
        Vector entryTable;
        int result = -1;
        if (this.contractTable != null && (entryTable = this.getContractValues(ch = groupChars.codePointAt(0))) != null && (index = RBCollationTables.getEntry(entryTable, groupChars, true)) != -1) {
            EntryPair pair = (EntryPair)entryTable.elementAt(index);
            result = pair.value;
        }
        return result;
    }

    private final int getCharOrder(int ch) {
        int order = this.mapping.elementAt(ch);
        if (order >= 0x7F000000) {
            Vector groupList = this.getContractValuesImpl(order - 0x7F000000);
            EntryPair pair = (EntryPair)groupList.firstElement();
            order = pair.value;
        }
        return order;
    }

    private Vector getContractValues(int ch) {
        int index = this.mapping.elementAt(ch);
        return this.getContractValuesImpl(index - 0x7F000000);
    }

    private Vector getContractValuesImpl(int index) {
        if (index >= 0) {
            return (Vector)this.contractTable.elementAt(index);
        }
        return null;
    }

    private final void addExpandOrder(String contractChars, String expandChars, int anOrder) throws ParseException {
        int tableIndex = this.addExpansion(anOrder, expandChars);
        if (contractChars.length() > 1) {
            char ch = contractChars.charAt(0);
            if (Character.isHighSurrogate(ch) && contractChars.length() == 2) {
                char ch2 = contractChars.charAt(1);
                if (Character.isLowSurrogate(ch2)) {
                    this.addOrder(Character.toCodePoint(ch, ch2), tableIndex);
                }
            } else {
                this.addContractOrder(contractChars, tableIndex);
            }
        } else {
            this.addOrder(contractChars.charAt(0), tableIndex);
        }
    }

    private final void addExpandOrder(int ch, String expandChars, int anOrder) throws ParseException {
        int tableIndex = this.addExpansion(anOrder, expandChars);
        this.addOrder(ch, tableIndex);
    }

    private int addExpansion(int anOrder, String expandChars) {
        if (this.expandTable == null) {
            this.expandTable = new Vector(20);
        }
        int offset = anOrder == -1 ? 0 : 1;
        int[] valueList = new int[expandChars.length() + offset];
        if (offset == 1) {
            valueList[0] = anOrder;
        }
        int j = offset;
        for (int i = 0; i < expandChars.length(); ++i) {
            int ch;
            int ch0 = expandChars.charAt(i);
            if (Character.isHighSurrogate((char)ch0)) {
                char ch1;
                if (++i == expandChars.length() || !Character.isLowSurrogate(ch1 = expandChars.charAt(i))) break;
                ch = Character.toCodePoint((char)ch0, ch1);
            } else {
                ch = ch0;
            }
            int mapValue = this.getCharOrder(ch);
            valueList[j++] = mapValue != -1 ? mapValue : 0x70000000 + ch;
        }
        if (j < valueList.length) {
            int[] tmpBuf = new int[j];
            while (--j >= 0) {
                tmpBuf[j] = valueList[j];
            }
            valueList = tmpBuf;
        }
        int tableIndex = 0x7E000000 + this.expandTable.size();
        this.expandTable.addElement(valueList);
        return tableIndex;
    }

    private void addContractFlags(String chars) {
        int len = chars.length();
        for (int i = 0; i < len; ++i) {
            int c0 = chars.charAt(i);
            int c = Character.isHighSurrogate((char)c0) ? Character.toCodePoint((char)c0, chars.charAt(++i)) : c0;
            this.contractFlags.put(c, 1);
        }
    }
}

