/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XExtData;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class Visual
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 56;
    }

    @Override
    public int getDataSize() {
        return Visual.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public Visual(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public Visual() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(Visual.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XExtData get_ext_data(int index) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XExtData(Native.getLong(this.pData + 0L) + (long)(index * 32)) : null;
    }

    public long get_ext_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_ext_data(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public long get_visualid() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_visualid(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    public int get_class() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_class(int v) {
        log.finest("");
        Native.putInt(this.pData + 16L, v);
    }

    public long get_red_mask() {
        log.finest("");
        return Native.getLong(this.pData + 24L);
    }

    public void set_red_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 24L, v);
    }

    public long get_green_mask() {
        log.finest("");
        return Native.getLong(this.pData + 32L);
    }

    public void set_green_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 32L, v);
    }

    public long get_blue_mask() {
        log.finest("");
        return Native.getLong(this.pData + 40L);
    }

    public void set_blue_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 40L, v);
    }

    public int get_bits_per_rgb() {
        log.finest("");
        return Native.getInt(this.pData + 48L);
    }

    public void set_bits_per_rgb(int v) {
        log.finest("");
        Native.putInt(this.pData + 48L, v);
    }

    public int get_map_entries() {
        log.finest("");
        return Native.getInt(this.pData + 52L);
    }

    public void set_map_entries(int v) {
        log.finest("");
        Native.putInt(this.pData + 52L, v);
    }

    @Override
    String getName() {
        return "Visual";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(320);
        ret.append("ext_data = ").append(this.get_ext_data()).append(", ");
        ret.append("visualid = ").append(this.get_visualid()).append(", ");
        ret.append("class = ").append(this.get_class()).append(", ");
        ret.append("red_mask = ").append(this.get_red_mask()).append(", ");
        ret.append("green_mask = ").append(this.get_green_mask()).append(", ");
        ret.append("blue_mask = ").append(this.get_blue_mask()).append(", ");
        ret.append("bits_per_rgb = ").append(this.get_bits_per_rgb()).append(", ");
        ret.append("map_entries = ").append(this.get_map_entries()).append(", ");
        return ret.toString();
    }
}

