/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.rmi.registry;

import com.sun.jndi.rmi.registry.AtomicNameParser;
import com.sun.jndi.rmi.registry.BindingEnumeration;
import com.sun.jndi.rmi.registry.NameClassPairEnumeration;
import com.sun.jndi.rmi.registry.ReferenceWrapper;
import com.sun.jndi.rmi.registry.RegistryContextFactory;
import com.sun.jndi.rmi.registry.RemoteReference;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.SocketSecurityException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;

public class RegistryContext
implements Context,
Referenceable {
    private Hashtable<String, Object> environment;
    private Registry registry;
    private String host;
    private int port;
    private static final NameParser nameParser = new AtomicNameParser();
    private static final String SOCKET_FACTORY = "com.sun.jndi.rmi.factory.socket";
    static final boolean trustURLCodebase;
    Reference reference = null;
    public static final String SECURITY_MGR = "java.naming.rmi.security.manager";

    public RegistryContext(String host, int port, Hashtable<?, ?> env) throws NamingException {
        Hashtable hashtable = this.environment = env == null ? new Hashtable(5) : env;
        if (this.environment.get(SECURITY_MGR) != null) {
            RegistryContext.installSecurityMgr();
        }
        if (host != null && host.charAt(0) == '[') {
            host = host.substring(1, host.length() - 1);
        }
        RMIClientSocketFactory socketFactory = (RMIClientSocketFactory)this.environment.get(SOCKET_FACTORY);
        this.registry = RegistryContext.getRegistry(host, port, socketFactory);
        this.host = host;
        this.port = port;
    }

    RegistryContext(RegistryContext ctx) {
        this.environment = (Hashtable)ctx.environment.clone();
        this.registry = ctx.registry;
        this.host = ctx.host;
        this.port = ctx.port;
        this.reference = ctx.reference;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Remote obj;
        if (name.isEmpty()) {
            return new RegistryContext(this);
        }
        try {
            obj = this.registry.lookup(name.get(0));
        }
        catch (NotBoundException e) {
            throw new NameNotFoundException(name.get(0));
        }
        catch (RemoteException e) {
            throw (NamingException)RegistryContext.wrapRemoteException(e).fillInStackTrace();
        }
        return this.decodeObject(obj, name.getPrefix(1));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: Cannot bind empty name");
        }
        try {
            this.registry.bind(name.get(0), this.encodeObject(obj, name.getPrefix(1)));
        }
        catch (AlreadyBoundException e) {
            NameAlreadyBoundException ne = new NameAlreadyBoundException(name.get(0));
            ne.setRootCause(e);
            throw ne;
        }
        catch (RemoteException e) {
            throw (NamingException)RegistryContext.wrapRemoteException(e).fillInStackTrace();
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: Cannot rebind empty name");
        }
        try {
            this.registry.rebind(name.get(0), this.encodeObject(obj, name.getPrefix(1)));
        }
        catch (RemoteException e) {
            throw (NamingException)RegistryContext.wrapRemoteException(e).fillInStackTrace();
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: Cannot unbind empty name");
        }
        try {
            this.registry.unbind(name.get(0));
        }
        catch (NotBoundException notBoundException) {
        }
        catch (RemoteException e) {
            throw (NamingException)RegistryContext.wrapRemoteException(e).fillInStackTrace();
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    @Override
    public void rename(String name, String newName) throws NamingException {
        this.rename(new CompositeName(name), new CompositeName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: can only list \"\"");
        }
        try {
            String[] names = this.registry.list();
            return new NameClassPairEnumeration(names);
        }
        catch (RemoteException e) {
            throw (NamingException)RegistryContext.wrapRemoteException(e).fillInStackTrace();
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new InvalidNameException("RegistryContext: can only list \"\"");
        }
        try {
            String[] names = this.registry.list();
            return new BindingEnumeration(this, names);
        }
        catch (RemoteException e) {
            throw (NamingException)RegistryContext.wrapRemoteException(e).fillInStackTrace();
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        return result.addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (propName.equals(SECURITY_MGR)) {
            RegistryContext.installSecurityMgr();
        }
        return this.environment.put(propName, propVal);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public void close() {
        this.environment = null;
        this.registry = null;
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }

    @Override
    public Reference getReference() throws NamingException {
        if (this.reference != null) {
            return (Reference)this.reference.clone();
        }
        if (this.host == null || this.host.equals("localhost")) {
            throw new ConfigurationException("Cannot create a reference for an RMI registry whose host was unspecified or specified as \"localhost\"");
        }
        String url = "rmi://";
        String string = url = this.host.indexOf(":") > -1 ? url + "[" + this.host + "]" : url + this.host;
        if (this.port > 0) {
            url = url + ":" + Integer.toString(this.port);
        }
        StringRefAddr addr = new StringRefAddr("URL", url);
        return new Reference(RegistryContext.class.getName(), addr, RegistryContextFactory.class.getName(), null);
    }

    public static NamingException wrapRemoteException(RemoteException re) {
        NamingException ne = re instanceof ConnectException ? new ServiceUnavailableException() : (re instanceof AccessException ? new NoPermissionException() : (re instanceof StubNotFoundException || re instanceof UnknownHostException || re instanceof SocketSecurityException ? new ConfigurationException() : (re instanceof ExportException || re instanceof ConnectIOException || re instanceof MarshalException || re instanceof UnmarshalException || re instanceof NoSuchObjectException ? new CommunicationException() : (re instanceof ServerException && re.detail instanceof RemoteException ? RegistryContext.wrapRemoteException((RemoteException)re.detail) : new NamingException()))));
        ne.setRootCause(re);
        return ne;
    }

    private static Registry getRegistry(String host, int port, RMIClientSocketFactory socketFactory) throws NamingException {
        try {
            if (socketFactory == null) {
                return LocateRegistry.getRegistry(host, port);
            }
            return LocateRegistry.getRegistry(host, port, socketFactory);
        }
        catch (RemoteException e) {
            throw (NamingException)RegistryContext.wrapRemoteException(e).fillInStackTrace();
        }
    }

    private static void installSecurityMgr() {
        try {
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Remote encodeObject(Object obj, Name name) throws NamingException, RemoteException {
        if ((obj = NamingManager.getStateToBind(obj, name, this, this.environment)) instanceof Remote) {
            return (Remote)obj;
        }
        if (obj instanceof Reference) {
            return new ReferenceWrapper((Reference)obj);
        }
        if (obj instanceof Referenceable) {
            return new ReferenceWrapper(((Referenceable)obj).getReference());
        }
        throw new IllegalArgumentException("RegistryContext: object to bind must be Remote, Reference, or Referenceable");
    }

    private Object decodeObject(Remote r, Name name) throws NamingException {
        try {
            Remote obj = r instanceof RemoteReference ? ((RemoteReference)r).getReference() : r;
            Reference ref = null;
            if (obj instanceof Reference) {
                ref = (Reference)((Object)obj);
            } else if (obj instanceof Referenceable) {
                ref = ((Referenceable)((Object)obj)).getReference();
            }
            if (ref != null && ref.getFactoryClassLocation() != null && !trustURLCodebase) {
                throw new ConfigurationException("The object factory is untrusted. Set the system property 'com.sun.jndi.rmi.object.trustURLCodebase' to 'true'.");
            }
            return NamingManager.getObjectInstance(obj, name, this, this.environment);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw (NamingException)RegistryContext.wrapRemoteException(e).fillInStackTrace();
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    static {
        String trust = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("com.sun.jndi.rmi.object.trustURLCodebase", "false");
            }
        });
        trustURLCodebase = "true".equalsIgnoreCase(trust);
    }
}

