/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import sun.swing.plaf.synth.DefaultSynthStyle;

class ParsedSynthStyle
extends DefaultSynthStyle {
    private static SynthPainter DELEGATING_PAINTER_INSTANCE = new DelegatingPainter();
    private PainterInfo[] _painters;

    private static PainterInfo[] mergePainterInfo(PainterInfo[] old, PainterInfo[] newPI) {
        if (old == null) {
            return newPI;
        }
        if (newPI == null) {
            return old;
        }
        int oldLength = old.length;
        int newLength = newPI.length;
        int dups = 0;
        PainterInfo[] merged = new PainterInfo[oldLength + newLength];
        System.arraycopy(old, 0, merged, 0, oldLength);
        for (int newCounter = 0; newCounter < newLength; ++newCounter) {
            boolean found = false;
            for (int oldCounter = 0; oldCounter < oldLength - dups; ++oldCounter) {
                if (!newPI[newCounter].equalsPainter(old[oldCounter])) continue;
                merged[oldCounter] = newPI[newCounter];
                ++dups;
                found = true;
                break;
            }
            if (found) continue;
            merged[oldLength + newCounter - dups] = newPI[newCounter];
        }
        if (dups > 0) {
            PainterInfo[] tmp = merged;
            merged = new PainterInfo[merged.length - dups];
            System.arraycopy(tmp, 0, merged, 0, merged.length);
        }
        return merged;
    }

    public ParsedSynthStyle() {
    }

    public ParsedSynthStyle(DefaultSynthStyle style) {
        super(style);
        if (style instanceof ParsedSynthStyle) {
            ParsedSynthStyle pStyle = (ParsedSynthStyle)style;
            if (pStyle._painters != null) {
                this._painters = pStyle._painters;
            }
        }
    }

    @Override
    public SynthPainter getPainter(SynthContext ss) {
        return DELEGATING_PAINTER_INSTANCE;
    }

    public void setPainters(PainterInfo[] info) {
        this._painters = info;
    }

    @Override
    public DefaultSynthStyle addTo(DefaultSynthStyle style) {
        if (!(style instanceof ParsedSynthStyle)) {
            style = new ParsedSynthStyle(style);
        }
        ParsedSynthStyle pStyle = (ParsedSynthStyle)super.addTo(style);
        pStyle._painters = ParsedSynthStyle.mergePainterInfo(pStyle._painters, this._painters);
        return pStyle;
    }

    private SynthPainter getBestPainter(SynthContext context, String method, int direction) {
        SynthPainter painter;
        StateInfo info = (StateInfo)this.getStateInfo(context.getComponentState());
        if (info != null && (painter = this.getBestPainter(info.getPainters(), method, direction)) != null) {
            return painter;
        }
        painter = this.getBestPainter(this._painters, method, direction);
        if (painter != null) {
            return painter;
        }
        return SynthPainter.NULL_PAINTER;
    }

    private SynthPainter getBestPainter(PainterInfo[] info, String method, int direction) {
        if (info != null) {
            SynthPainter nullPainter = null;
            SynthPainter methodPainter = null;
            for (int counter = info.length - 1; counter >= 0; --counter) {
                PainterInfo pi = info[counter];
                if (pi.getMethod() == method) {
                    if (pi.getDirection() == direction) {
                        return pi.getPainter();
                    }
                    if (methodPainter != null || pi.getDirection() != -1) continue;
                    methodPainter = pi.getPainter();
                    continue;
                }
                if (nullPainter != null || pi.getMethod() != null) continue;
                nullPainter = pi.getPainter();
            }
            if (methodPainter != null) {
                return methodPainter;
            }
            return nullPainter;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        if (this._painters != null) {
            text.append(",painters=[");
            for (int i = 0; i < this._painters.length; ++i) {
                text.append(this._painters[i].toString());
            }
            text.append("]");
        }
        return text.toString();
    }

    private static class DelegatingPainter
    extends SynthPainter {
        private DelegatingPainter() {
        }

        private static SynthPainter getPainter(SynthContext context, String method, int direction) {
            return ((ParsedSynthStyle)context.getStyle()).getBestPainter(context, method, direction);
        }

        @Override
        public void paintArrowButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "arrowbuttonbackground", -1).paintArrowButtonBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintArrowButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "arrowbuttonborder", -1).paintArrowButtonBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintArrowButtonForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "arrowbuttonforeground", direction).paintArrowButtonForeground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "buttonbackground", -1).paintButtonBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "buttonborder", -1).paintButtonBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintCheckBoxMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "checkboxmenuitembackground", -1).paintCheckBoxMenuItemBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintCheckBoxMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "checkboxmenuitemborder", -1).paintCheckBoxMenuItemBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintCheckBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "checkboxbackground", -1).paintCheckBoxBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintCheckBoxBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "checkboxborder", -1).paintCheckBoxBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintColorChooserBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "colorchooserbackground", -1).paintColorChooserBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintColorChooserBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "colorchooserborder", -1).paintColorChooserBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintComboBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "comboboxbackground", -1).paintComboBoxBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintComboBoxBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "comboboxborder", -1).paintComboBoxBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintDesktopIconBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "desktopiconbackground", -1).paintDesktopIconBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintDesktopIconBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "desktopiconborder", -1).paintDesktopIconBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintDesktopPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "desktoppanebackground", -1).paintDesktopPaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintDesktopPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "desktoppaneborder", -1).paintDesktopPaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintEditorPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "editorpanebackground", -1).paintEditorPaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintEditorPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "editorpaneborder", -1).paintEditorPaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintFileChooserBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "filechooserbackground", -1).paintFileChooserBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintFileChooserBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "filechooserborder", -1).paintFileChooserBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintFormattedTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "formattedtextfieldbackground", -1).paintFormattedTextFieldBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintFormattedTextFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "formattedtextfieldborder", -1).paintFormattedTextFieldBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintInternalFrameTitlePaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "internalframetitlepanebackground", -1).paintInternalFrameTitlePaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintInternalFrameTitlePaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "internalframetitlepaneborder", -1).paintInternalFrameTitlePaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintInternalFrameBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "internalframebackground", -1).paintInternalFrameBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintInternalFrameBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "internalframeborder", -1).paintInternalFrameBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintLabelBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "labelbackground", -1).paintLabelBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintLabelBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "labelborder", -1).paintLabelBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintListBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "listbackground", -1).paintListBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintListBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "listborder", -1).paintListBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintMenuBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "menubarbackground", -1).paintMenuBarBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintMenuBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "menubarborder", -1).paintMenuBarBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "menuitembackground", -1).paintMenuItemBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "menuitemborder", -1).paintMenuItemBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "menubackground", -1).paintMenuBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintMenuBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "menuborder", -1).paintMenuBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintOptionPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "optionpanebackground", -1).paintOptionPaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintOptionPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "optionpaneborder", -1).paintOptionPaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintPanelBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "panelbackground", -1).paintPanelBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintPanelBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "panelborder", -1).paintPanelBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintPasswordFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "passwordfieldbackground", -1).paintPasswordFieldBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintPasswordFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "passwordfieldborder", -1).paintPasswordFieldBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintPopupMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "popupmenubackground", -1).paintPopupMenuBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintPopupMenuBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "popupmenuborder", -1).paintPopupMenuBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "progressbarbackground", -1).paintProgressBarBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "progressbarbackground", direction).paintProgressBarBackground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "progressbarborder", -1).paintProgressBarBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "progressbarborder", direction).paintProgressBarBorder(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintProgressBarForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "progressbarforeground", direction).paintProgressBarForeground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintRadioButtonMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "radiobuttonmenuitembackground", -1).paintRadioButtonMenuItemBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintRadioButtonMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "radiobuttonmenuitemborder", -1).paintRadioButtonMenuItemBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintRadioButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "radiobuttonbackground", -1).paintRadioButtonBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintRadioButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "radiobuttonborder", -1).paintRadioButtonBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintRootPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "rootpanebackground", -1).paintRootPaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintRootPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "rootpaneborder", -1).paintRootPaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintScrollBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "scrollbarbackground", -1).paintScrollBarBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintScrollBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "scrollbarbackground", direction).paintScrollBarBackground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintScrollBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "scrollbarborder", -1).paintScrollBarBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintScrollBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "scrollbarborder", orientation).paintScrollBarBorder(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintScrollBarThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "scrollbarthumbbackground", direction).paintScrollBarThumbBackground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintScrollBarThumbBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "scrollbarthumbborder", direction).paintScrollBarThumbBorder(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintScrollBarTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "scrollbartrackbackground", -1).paintScrollBarTrackBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintScrollBarTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "scrollbartrackbackground", direction).paintScrollBarTrackBackground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintScrollBarTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "scrollbartrackborder", -1).paintScrollBarTrackBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintScrollBarTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "scrollbartrackborder", orientation).paintScrollBarTrackBorder(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintScrollPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "scrollpanebackground", -1).paintScrollPaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintScrollPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "scrollpaneborder", -1).paintScrollPaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintSeparatorBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "separatorbackground", -1).paintSeparatorBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintSeparatorBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "separatorbackground", orientation).paintSeparatorBackground(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintSeparatorBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "separatorborder", -1).paintSeparatorBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintSeparatorBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "separatorborder", orientation).paintSeparatorBorder(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintSeparatorForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "separatorforeground", direction).paintSeparatorForeground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSliderBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "sliderbackground", -1).paintSliderBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintSliderBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "sliderbackground", direction).paintSliderBackground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSliderBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "sliderborder", -1).paintSliderBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintSliderBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "sliderborder", direction).paintSliderBorder(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSliderThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "sliderthumbbackground", direction).paintSliderThumbBackground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSliderThumbBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "sliderthumbborder", direction).paintSliderThumbBorder(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSliderTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "slidertrackbackground", -1).paintSliderTrackBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintSliderTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "slidertrackbackground", direction).paintSliderTrackBackground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSliderTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "slidertrackborder", -1).paintSliderTrackBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintSliderTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "slidertrackborder", direction).paintSliderTrackBorder(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSpinnerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "spinnerbackground", -1).paintSpinnerBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintSpinnerBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "spinnerborder", -1).paintSpinnerBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "splitpanedividerbackground", -1).paintSplitPaneDividerBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "splitpanedividerbackground", orientation).paintSplitPaneDividerBackground(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintSplitPaneDividerForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "splitpanedividerforeground", direction).paintSplitPaneDividerForeground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSplitPaneDragDivider(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "splitpanedragdivider", direction).paintSplitPaneDragDivider(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintSplitPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "splitpanebackground", -1).paintSplitPaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintSplitPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "splitpaneborder", -1).paintSplitPaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTabbedPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tabbedpanebackground", -1).paintTabbedPaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTabbedPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tabbedpaneborder", -1).paintTabbedPaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTabbedPaneTabAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tabbedpanetabareabackground", -1).paintTabbedPaneTabAreaBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTabbedPaneTabAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "tabbedpanetabareabackground", orientation).paintTabbedPaneTabAreaBackground(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintTabbedPaneTabAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tabbedpanetabareaborder", -1).paintTabbedPaneTabAreaBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTabbedPaneTabAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "tabbedpanetabareaborder", orientation).paintTabbedPaneTabAreaBorder(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintTabbedPaneTabBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "tabbedpanetabbackground", -1).paintTabbedPaneTabBackground(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintTabbedPaneTabBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex, int direction) {
            DelegatingPainter.getPainter(context, "tabbedpanetabbackground", direction).paintTabbedPaneTabBackground(context, g, x, y, w, h, tabIndex, direction);
        }

        @Override
        public void paintTabbedPaneTabBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            DelegatingPainter.getPainter(context, "tabbedpanetabborder", -1).paintTabbedPaneTabBorder(context, g, x, y, w, h, direction);
        }

        @Override
        public void paintTabbedPaneTabBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex, int direction) {
            DelegatingPainter.getPainter(context, "tabbedpanetabborder", direction).paintTabbedPaneTabBorder(context, g, x, y, w, h, tabIndex, direction);
        }

        @Override
        public void paintTabbedPaneContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tabbedpanecontentbackground", -1).paintTabbedPaneContentBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTabbedPaneContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tabbedpanecontentborder", -1).paintTabbedPaneContentBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTableHeaderBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tableheaderbackground", -1).paintTableHeaderBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTableHeaderBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tableheaderborder", -1).paintTableHeaderBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTableBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tablebackground", -1).paintTableBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTableBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tableborder", -1).paintTableBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTextAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "textareabackground", -1).paintTextAreaBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTextAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "textareaborder", -1).paintTextAreaBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTextPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "textpanebackground", -1).paintTextPaneBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTextPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "textpaneborder", -1).paintTextPaneBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "textfieldbackground", -1).paintTextFieldBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTextFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "textfieldborder", -1).paintTextFieldBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintToggleButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "togglebuttonbackground", -1).paintToggleButtonBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintToggleButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "togglebuttonborder", -1).paintToggleButtonBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintToolBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "toolbarbackground", -1).paintToolBarBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintToolBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "toolbarbackground", orientation).paintToolBarBackground(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintToolBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "toolbarborder", -1).paintToolBarBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintToolBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "toolbarborder", orientation).paintToolBarBorder(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintToolBarContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "toolbarcontentbackground", -1).paintToolBarContentBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintToolBarContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "toolbarcontentbackground", orientation).paintToolBarContentBackground(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintToolBarContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "toolbarcontentborder", -1).paintToolBarContentBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintToolBarContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "toolbarcontentborder", orientation).paintToolBarContentBorder(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintToolBarDragWindowBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "toolbardragwindowbackground", -1).paintToolBarDragWindowBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintToolBarDragWindowBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "toolbardragwindowbackground", orientation).paintToolBarDragWindowBackground(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintToolBarDragWindowBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "toolbardragwindowborder", -1).paintToolBarDragWindowBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintToolBarDragWindowBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            DelegatingPainter.getPainter(context, "toolbardragwindowborder", orientation).paintToolBarDragWindowBorder(context, g, x, y, w, h, orientation);
        }

        @Override
        public void paintToolTipBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tooltipbackground", -1).paintToolTipBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintToolTipBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "tooltipborder", -1).paintToolTipBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTreeBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "treebackground", -1).paintTreeBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTreeBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "treeborder", -1).paintTreeBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTreeCellBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "treecellbackground", -1).paintTreeCellBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintTreeCellBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "treecellborder", -1).paintTreeCellBorder(context, g, x, y, w, h);
        }

        @Override
        public void paintTreeCellFocus(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "treecellfocus", -1).paintTreeCellFocus(context, g, x, y, w, h);
        }

        @Override
        public void paintViewportBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "viewportbackground", -1).paintViewportBackground(context, g, x, y, w, h);
        }

        @Override
        public void paintViewportBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            DelegatingPainter.getPainter(context, "viewportborder", -1).paintViewportBorder(context, g, x, y, w, h);
        }
    }

    private static class AggregatePainter
    extends SynthPainter {
        private List<SynthPainter> painters = new LinkedList<SynthPainter>();

        AggregatePainter(SynthPainter painter) {
            this.painters.add(painter);
        }

        void addPainter(SynthPainter painter) {
            if (painter != null) {
                this.painters.add(painter);
            }
        }

        @Override
        public void paintArrowButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintArrowButtonBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintArrowButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintArrowButtonBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintArrowButtonForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int direction) {
            for (SynthPainter painter : this.painters) {
                painter.paintArrowButtonForeground(context, g, x, y, w, h, direction);
            }
        }

        @Override
        public void paintButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintButtonBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintButtonBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintCheckBoxMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintCheckBoxMenuItemBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintCheckBoxMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintCheckBoxMenuItemBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintCheckBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintCheckBoxBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintCheckBoxBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintCheckBoxBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintColorChooserBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintColorChooserBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintColorChooserBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintColorChooserBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintComboBoxBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintComboBoxBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintComboBoxBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintComboBoxBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintDesktopIconBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintDesktopIconBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintDesktopIconBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintDesktopIconBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintDesktopPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintDesktopPaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintDesktopPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintDesktopPaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintEditorPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintEditorPaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintEditorPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintEditorPaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintFileChooserBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintFileChooserBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintFileChooserBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintFileChooserBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintFormattedTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintFormattedTextFieldBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintFormattedTextFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintFormattedTextFieldBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintInternalFrameTitlePaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintInternalFrameTitlePaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintInternalFrameTitlePaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintInternalFrameTitlePaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintInternalFrameBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintInternalFrameBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintInternalFrameBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintInternalFrameBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintLabelBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintLabelBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintLabelBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintLabelBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintListBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintListBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintListBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintListBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintMenuBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintMenuBarBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintMenuBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintMenuBarBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintMenuItemBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintMenuItemBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintMenuBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintMenuBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintMenuBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintOptionPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintOptionPaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintOptionPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintOptionPaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintPanelBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintPanelBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintPanelBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintPanelBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintPasswordFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintPasswordFieldBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintPasswordFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintPasswordFieldBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintPopupMenuBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintPopupMenuBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintPopupMenuBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintPopupMenuBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintProgressBarBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintProgressBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintProgressBarBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintProgressBarBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintProgressBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintProgressBarBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintProgressBarForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintProgressBarForeground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintRadioButtonMenuItemBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintRadioButtonMenuItemBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintRadioButtonMenuItemBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintRadioButtonMenuItemBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintRadioButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintRadioButtonBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintRadioButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintRadioButtonBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintRootPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintRootPaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintRootPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintRootPaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintScrollBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintScrollBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintScrollBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintScrollBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintScrollBarThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarThumbBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintScrollBarThumbBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarThumbBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintScrollBarTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarTrackBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintScrollBarTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarTrackBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintScrollBarTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarTrackBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintScrollBarTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollBarTrackBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintScrollPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollPaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintScrollPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintScrollPaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSeparatorBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSeparatorBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSeparatorBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSeparatorBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSeparatorBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSeparatorBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSeparatorBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSeparatorBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSeparatorForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSeparatorForeground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSliderBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSliderBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSliderBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSliderBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSliderThumbBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderThumbBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSliderThumbBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderThumbBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSliderTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderTrackBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSliderTrackBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderTrackBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSliderTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderTrackBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSliderTrackBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSliderTrackBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSpinnerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSpinnerBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSpinnerBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSpinnerBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSplitPaneDividerBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSplitPaneDividerBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSplitPaneDividerBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSplitPaneDividerForeground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSplitPaneDividerForeground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSplitPaneDragDivider(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintSplitPaneDragDivider(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintSplitPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSplitPaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintSplitPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintSplitPaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTabbedPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTabbedPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTabbedPaneTabAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneTabAreaBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTabbedPaneTabAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneTabAreaBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintTabbedPaneTabAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneTabAreaBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTabbedPaneTabAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneTabAreaBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintTabbedPaneTabBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneTabBackground(context, g, x, y, w, h, tabIndex);
            }
        }

        @Override
        public void paintTabbedPaneTabBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneTabBackground(context, g, x, y, w, h, tabIndex, orientation);
            }
        }

        @Override
        public void paintTabbedPaneTabBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneTabBorder(context, g, x, y, w, h, tabIndex);
            }
        }

        @Override
        public void paintTabbedPaneTabBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int tabIndex, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneTabBorder(context, g, x, y, w, h, tabIndex, orientation);
            }
        }

        @Override
        public void paintTabbedPaneContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneContentBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTabbedPaneContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTabbedPaneContentBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTableHeaderBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTableHeaderBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTableHeaderBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTableHeaderBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTableBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTableBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTableBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTableBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTextAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTextAreaBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTextAreaBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTextAreaBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTextPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTextPaneBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTextPaneBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTextPaneBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTextFieldBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTextFieldBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTextFieldBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToggleButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToggleButtonBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToggleButtonBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToggleButtonBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToolBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToolBarBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintToolBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToolBarBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintToolBarContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarContentBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToolBarContentBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarContentBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintToolBarContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarContentBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToolBarContentBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarContentBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintToolBarDragWindowBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarDragWindowBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToolBarDragWindowBackground(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarDragWindowBackground(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintToolBarDragWindowBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarDragWindowBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToolBarDragWindowBorder(SynthContext context, Graphics g, int x, int y, int w, int h, int orientation) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolBarDragWindowBorder(context, g, x, y, w, h, orientation);
            }
        }

        @Override
        public void paintToolTipBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolTipBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintToolTipBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintToolTipBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTreeBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTreeBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTreeBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTreeBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTreeCellBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTreeCellBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTreeCellBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTreeCellBorder(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintTreeCellFocus(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintTreeCellFocus(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintViewportBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintViewportBackground(context, g, x, y, w, h);
            }
        }

        @Override
        public void paintViewportBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            for (SynthPainter painter : this.painters) {
                painter.paintViewportBorder(context, g, x, y, w, h);
            }
        }
    }

    static class PainterInfo {
        private String _method;
        private SynthPainter _painter;
        private int _direction;

        PainterInfo(String method, SynthPainter painter, int direction) {
            if (method != null) {
                this._method = method.intern();
            }
            this._painter = painter;
            this._direction = direction;
        }

        void addPainter(SynthPainter painter) {
            if (!(this._painter instanceof AggregatePainter)) {
                this._painter = new AggregatePainter(this._painter);
            }
            ((AggregatePainter)this._painter).addPainter(painter);
        }

        String getMethod() {
            return this._method;
        }

        SynthPainter getPainter() {
            return this._painter;
        }

        int getDirection() {
            return this._direction;
        }

        boolean equalsPainter(PainterInfo info) {
            return this._method == info._method && this._direction == info._direction;
        }

        public String toString() {
            return "PainterInfo {method=" + this._method + ",direction=" + this._direction + ",painter=" + this._painter + "}";
        }
    }

    static class StateInfo
    extends DefaultSynthStyle.StateInfo {
        private PainterInfo[] _painterInfo;

        public StateInfo() {
        }

        public StateInfo(DefaultSynthStyle.StateInfo info) {
            super(info);
            if (info instanceof StateInfo) {
                this._painterInfo = ((StateInfo)info)._painterInfo;
            }
        }

        public void setPainters(PainterInfo[] painterInfo) {
            this._painterInfo = painterInfo;
        }

        public PainterInfo[] getPainters() {
            return this._painterInfo;
        }

        @Override
        public Object clone() {
            return new StateInfo(this);
        }

        @Override
        public DefaultSynthStyle.StateInfo addTo(DefaultSynthStyle.StateInfo info) {
            if (!(info instanceof StateInfo)) {
                info = new StateInfo(info);
            } else {
                info = super.addTo(info);
                StateInfo si = (StateInfo)info;
                si._painterInfo = ParsedSynthStyle.mergePainterInfo(si._painterInfo, this._painterInfo);
            }
            return info;
        }

        @Override
        public String toString() {
            StringBuffer text = new StringBuffer(super.toString());
            text.append(",painters=[");
            if (this._painterInfo != null) {
                for (int i = 0; i < this._painterInfo.length; ++i) {
                    text.append("    ").append(this._painterInfo[i].toString());
                }
            }
            text.append("]");
            return text.toString();
        }
    }
}

