/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.JMX;

public class DescriptorCache {
    private static final DescriptorCache instance = new DescriptorCache();
    private final WeakHashMap<ImmutableDescriptor, WeakReference<ImmutableDescriptor>> map = new WeakHashMap();

    private DescriptorCache() {
    }

    static DescriptorCache getInstance() {
        return instance;
    }

    public static DescriptorCache getInstance(JMX proof) {
        if (proof != null) {
            return instance;
        }
        return null;
    }

    public ImmutableDescriptor get(ImmutableDescriptor descriptor) {
        ImmutableDescriptor got;
        WeakReference<ImmutableDescriptor> wr = this.map.get(descriptor);
        ImmutableDescriptor immutableDescriptor = got = wr == null ? null : (ImmutableDescriptor)wr.get();
        if (got != null) {
            return got;
        }
        this.map.put(descriptor, new WeakReference<ImmutableDescriptor>(descriptor));
        return descriptor;
    }

    public ImmutableDescriptor union(Descriptor ... descriptors) {
        return this.get(ImmutableDescriptor.union(descriptors));
    }
}

