/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.AsynchronousChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessController;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import sun.misc.InnocuousThread;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.Groupable;
import sun.nio.ch.PendingFuture;
import sun.security.action.GetIntegerAction;

class Invoker {
    private static final int maxHandlerInvokeCount = AccessController.doPrivileged(new GetIntegerAction("sun.nio.ch.maxCompletionHandlersOnStack", 16));
    private static final ThreadLocal<GroupAndInvokeCount> myGroupAndInvokeCount = new ThreadLocal<GroupAndInvokeCount>(){

        @Override
        protected GroupAndInvokeCount initialValue() {
            return null;
        }
    };

    private Invoker() {
    }

    static void bindToGroup(AsynchronousChannelGroupImpl group) {
        myGroupAndInvokeCount.set(new GroupAndInvokeCount(group));
    }

    static GroupAndInvokeCount getGroupAndInvokeCount() {
        return myGroupAndInvokeCount.get();
    }

    static boolean isBoundToAnyGroup() {
        return myGroupAndInvokeCount.get() != null;
    }

    static boolean mayInvokeDirect(GroupAndInvokeCount myGroupAndInvokeCount, AsynchronousChannelGroupImpl group) {
        return myGroupAndInvokeCount != null && myGroupAndInvokeCount.group() == group && myGroupAndInvokeCount.invokeCount() < maxHandlerInvokeCount;
    }

    static <V, A> void invokeUnchecked(CompletionHandler<V, ? super A> handler, A attachment, V value, Throwable exc) {
        Thread me;
        if (exc == null) {
            handler.completed(value, attachment);
        } else {
            handler.failed(exc, attachment);
        }
        Thread.interrupted();
        if (System.getSecurityManager() != null && (me = Thread.currentThread()) instanceof InnocuousThread) {
            GroupAndInvokeCount thisGroupAndInvokeCount = myGroupAndInvokeCount.get();
            ((InnocuousThread)me).eraseThreadLocals();
            if (thisGroupAndInvokeCount != null) {
                myGroupAndInvokeCount.set(thisGroupAndInvokeCount);
            }
        }
    }

    static <V, A> void invokeDirect(GroupAndInvokeCount myGroupAndInvokeCount, CompletionHandler<V, ? super A> handler, A attachment, V result, Throwable exc) {
        myGroupAndInvokeCount.incrementInvokeCount();
        Invoker.invokeUnchecked(handler, attachment, result, exc);
    }

    static <V, A> void invoke(AsynchronousChannel channel, CompletionHandler<V, ? super A> handler, A attachment, V result, Throwable exc) {
        boolean invokeDirect = false;
        boolean identityOkay = false;
        GroupAndInvokeCount thisGroupAndInvokeCount = myGroupAndInvokeCount.get();
        if (thisGroupAndInvokeCount != null) {
            if (thisGroupAndInvokeCount.group() == ((Groupable)((Object)channel)).group()) {
                identityOkay = true;
            }
            if (identityOkay && thisGroupAndInvokeCount.invokeCount() < maxHandlerInvokeCount) {
                invokeDirect = true;
            }
        }
        if (invokeDirect) {
            Invoker.invokeDirect(thisGroupAndInvokeCount, handler, attachment, result, exc);
        } else {
            try {
                Invoker.invokeIndirectly(channel, handler, attachment, result, exc);
            }
            catch (RejectedExecutionException ree) {
                if (identityOkay) {
                    Invoker.invokeDirect(thisGroupAndInvokeCount, handler, attachment, result, exc);
                }
                throw new ShutdownChannelGroupException();
            }
        }
    }

    static <V, A> void invokeIndirectly(AsynchronousChannel channel, final CompletionHandler<V, ? super A> handler, final A attachment, final V result, final Throwable exc) {
        try {
            ((Groupable)((Object)channel)).group().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    GroupAndInvokeCount thisGroupAndInvokeCount = (GroupAndInvokeCount)myGroupAndInvokeCount.get();
                    if (thisGroupAndInvokeCount != null) {
                        thisGroupAndInvokeCount.setInvokeCount(1);
                    }
                    Invoker.invokeUnchecked(handler, attachment, result, exc);
                }
            });
        }
        catch (RejectedExecutionException ree) {
            throw new ShutdownChannelGroupException();
        }
    }

    static <V, A> void invokeIndirectly(final CompletionHandler<V, ? super A> handler, final A attachment, final V value, final Throwable exc, Executor executor) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Invoker.invokeUnchecked(handler, attachment, value, exc);
                }
            });
        }
        catch (RejectedExecutionException ree) {
            throw new ShutdownChannelGroupException();
        }
    }

    static void invokeOnThreadInThreadPool(Groupable channel, Runnable task) {
        GroupAndInvokeCount thisGroupAndInvokeCount = myGroupAndInvokeCount.get();
        AsynchronousChannelGroupImpl targetGroup = channel.group();
        boolean invokeDirect = thisGroupAndInvokeCount == null ? false : thisGroupAndInvokeCount.group == targetGroup;
        try {
            if (invokeDirect) {
                task.run();
            } else {
                targetGroup.executeOnPooledThread(task);
            }
        }
        catch (RejectedExecutionException ree) {
            throw new ShutdownChannelGroupException();
        }
    }

    static <V, A> void invokeUnchecked(PendingFuture<V, A> future) {
        assert (future.isDone());
        CompletionHandler<V, A> handler = future.handler();
        if (handler != null) {
            Invoker.invokeUnchecked(handler, future.attachment(), future.value(), future.exception());
        }
    }

    static <V, A> void invoke(PendingFuture<V, A> future) {
        assert (future.isDone());
        CompletionHandler<V, A> handler = future.handler();
        if (handler != null) {
            Invoker.invoke(future.channel(), handler, future.attachment(), future.value(), future.exception());
        }
    }

    static <V, A> void invokeIndirectly(PendingFuture<V, A> future) {
        assert (future.isDone());
        CompletionHandler<V, A> handler = future.handler();
        if (handler != null) {
            Invoker.invokeIndirectly(future.channel(), handler, future.attachment(), future.value(), future.exception());
        }
    }

    static class GroupAndInvokeCount {
        private final AsynchronousChannelGroupImpl group;
        private int handlerInvokeCount;

        GroupAndInvokeCount(AsynchronousChannelGroupImpl group) {
            this.group = group;
        }

        AsynchronousChannelGroupImpl group() {
            return this.group;
        }

        int invokeCount() {
            return this.handlerInvokeCount;
        }

        void setInvokeCount(int value) {
            this.handlerInvokeCount = value;
        }

        void resetInvokeCount() {
            this.handlerInvokeCount = 0;
        }

        void incrementInvokeCount() {
            ++this.handlerInvokeCount;
        }
    }
}

