/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.binding.HTTPBindingImpl;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.developer.BindingTypeFeature;
import com.sun.xml.internal.ws.developer.MemberSubmissionAddressingFeature;
import java.util.Collections;
import java.util.List;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;

public abstract class BindingImpl
implements WSBinding {
    protected HandlerConfiguration handlerConfig;
    private final BindingID bindingId;
    protected final WebServiceFeatureList features = new WebServiceFeatureList();
    protected Service.Mode serviceMode = Service.Mode.PAYLOAD;

    protected BindingImpl(BindingID bindingId) {
        this.bindingId = bindingId;
        this.handlerConfig = new HandlerConfiguration(Collections.emptySet(), Collections.emptyList());
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    public void setMode(@NotNull Service.Mode mode) {
        this.serviceMode = Service.Mode.MESSAGE;
    }

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        AddressingVersion addressingVersion = this.features.isEnabled(AddressingFeature.class) ? AddressingVersion.W3C : (this.features.isEnabled(MemberSubmissionAddressingFeature.class) ? AddressingVersion.MEMBER : null);
        return addressingVersion;
    }

    @NotNull
    public final Codec createCodec() {
        BindingImpl.initializeJavaActivationHandlers();
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingId) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId);
    }

    public static BindingImpl create(@NotNull BindingID bindingId, WebServiceFeature[] features) {
        for (WebServiceFeature feature : features) {
            if (!(feature instanceof BindingTypeFeature)) continue;
            BindingTypeFeature f = (BindingTypeFeature)feature;
            bindingId = BindingID.parse(f.getBindingId());
        }
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId, features);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    @Override
    public String getBindingID() {
        return this.bindingId.toString();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getFeature(@NotNull Class<F> featureType) {
        return this.features.get(featureType);
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Class<? extends WebServiceFeature> feature) {
        return this.features.isEnabled(feature);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFeatures() {
        return this.features;
    }

    public void setFeatures(WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            for (WebServiceFeature f : newFeatures) {
                this.features.add(f);
            }
        }
    }

    public void addFeature(@NotNull WebServiceFeature newFeature) {
        this.features.add(newFeature);
    }

    public static void initializeJavaActivationHandlers() {
        try {
            MailcapCommandMap mailMap;
            CommandMap map = CommandMap.getDefaultCommandMap();
            if (map instanceof MailcapCommandMap && !BindingImpl.cmdMapInitialized(mailMap = (MailcapCommandMap)map)) {
                mailMap.addMailcap("text/xml;;x-java-content-handler=com.sun.xml.internal.ws.encoding.XmlDataContentHandler");
                mailMap.addMailcap("application/xml;;x-java-content-handler=com.sun.xml.internal.ws.encoding.XmlDataContentHandler");
                mailMap.addMailcap("image/*;;x-java-content-handler=com.sun.xml.internal.ws.encoding.ImageDataContentHandler");
                mailMap.addMailcap("text/plain;;x-java-content-handler=com.sun.xml.internal.ws.encoding.StringDataContentHandler");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean cmdMapInitialized(MailcapCommandMap mailMap) {
        CommandInfo[] commands = mailMap.getAllCommands("text/xml");
        if (commands == null || commands.length == 0) {
            return false;
        }
        String saajClassName = "com.sun.xml.internal.messaging.saaj.soap.XmlDataContentHandler";
        String jaxwsClassName = "com.sun.xml.internal.ws.encoding.XmlDataContentHandler";
        for (CommandInfo command : commands) {
            String commandClass = command.getCommandClass();
            if (!saajClassName.equals(commandClass) && !jaxwsClassName.equals(commandClass)) continue;
            return true;
        }
        return false;
    }
}

