/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.common;

import com.sun.imageio.plugins.common.BitFile;
import com.sun.imageio.plugins.common.LZWStringTable;
import java.io.IOException;
import java.io.PrintStream;
import javax.imageio.stream.ImageOutputStream;

public class LZWCompressor {
    int codeSize;
    int clearCode;
    int endOfInfo;
    int numBits;
    int limit;
    short prefix;
    BitFile bf;
    LZWStringTable lzss;
    boolean tiffFudge;

    public LZWCompressor(ImageOutputStream out, int codeSize, boolean TIFF) throws IOException {
        this.bf = new BitFile(out, !TIFF);
        this.codeSize = codeSize;
        this.tiffFudge = TIFF;
        this.clearCode = 1 << codeSize;
        this.endOfInfo = this.clearCode + 1;
        this.numBits = codeSize + 1;
        this.limit = (1 << this.numBits) - 1;
        if (this.tiffFudge) {
            --this.limit;
        }
        this.prefix = (short)-1;
        this.lzss = new LZWStringTable();
        this.lzss.clearTable(codeSize);
        this.bf.writeBits(this.clearCode, this.numBits);
    }

    public void compress(byte[] buf, int offset, int length) throws IOException {
        int maxOffset = offset + length;
        for (int idx = offset; idx < maxOffset; ++idx) {
            byte c = buf[idx];
            short index = this.lzss.findCharString(this.prefix, c);
            if (index != -1) {
                this.prefix = index;
                continue;
            }
            this.bf.writeBits(this.prefix, this.numBits);
            if (this.lzss.addCharString(this.prefix, c) > this.limit) {
                if (this.numBits == 12) {
                    this.bf.writeBits(this.clearCode, this.numBits);
                    this.lzss.clearTable(this.codeSize);
                    this.numBits = this.codeSize + 1;
                } else {
                    ++this.numBits;
                }
                this.limit = (1 << this.numBits) - 1;
                if (this.tiffFudge) {
                    --this.limit;
                }
            }
            this.prefix = (short)((short)c & 0xFF);
        }
    }

    public void flush() throws IOException {
        if (this.prefix != -1) {
            this.bf.writeBits(this.prefix, this.numBits);
        }
        this.bf.writeBits(this.endOfInfo, this.numBits);
        this.bf.flush();
    }

    public void dump(PrintStream out) {
        this.lzss.dump(out);
    }
}

