/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class DSAParameters
extends AlgorithmParametersSpi {
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger g;

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DSAParameterSpec)paramSpec).getP();
        this.q = ((DSAParameterSpec)paramSpec).getQ();
        this.g = ((DSAParameterSpec)paramSpec).getG();
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        DerValue encodedParams = new DerValue(params);
        if (encodedParams.tag != 48) {
            throw new IOException("DSA params parsing error");
        }
        encodedParams.data.reset();
        this.p = encodedParams.data.getBigInteger();
        this.q = encodedParams.data.getBigInteger();
        this.g = encodedParams.data.getBigInteger();
        if (encodedParams.data.available() != 0) {
            throw new IOException("encoded params have " + encodedParams.data.available() + " extra bytes");
        }
    }

    @Override
    protected void engineInit(byte[] params, String decodingMethod) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        try {
            Class<T> dsaParamSpec = Class.forName("java.security.spec.DSAParameterSpec");
            if (dsaParamSpec.isAssignableFrom(paramSpec)) {
                return (T)((AlgorithmParameterSpec)paramSpec.cast(new DSAParameterSpec(this.p, this.q, this.g)));
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        bytes.putInteger(this.p);
        bytes.putInteger(this.q);
        bytes.putInteger(this.g);
        out.write((byte)48, bytes);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return "\n\tp: " + Debug.toHexString(this.p) + "\n\tq: " + Debug.toHexString(this.q) + "\n\tg: " + Debug.toHexString(this.g) + "\n";
    }
}

