/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalDesktopIconUI
extends BasicDesktopIconUI {
    JButton button;
    JLabel label;
    TitleListener titleListener;
    private int width;

    public static ComponentUI createUI(JComponent c) {
        return new MetalDesktopIconUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(this.desktopIcon, "DesktopIcon.background", "DesktopIcon.foreground", "DesktopIcon.font");
        this.width = UIManager.getInt("DesktopIcon.width");
    }

    @Override
    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        Icon icon = this.frame.getFrameIcon();
        String title = this.frame.getTitle();
        this.button = new JButton(title, icon);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetalDesktopIconUI.this.deiconize();
            }
        });
        this.button.setFont(this.desktopIcon.getFont());
        this.button.setBackground(this.desktopIcon.getBackground());
        this.button.setForeground(this.desktopIcon.getForeground());
        int buttonH = this.button.getPreferredSize().height;
        MetalBumps drag = new MetalBumps(buttonH / 3, buttonH, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
        this.label = new JLabel(drag);
        this.label.setBorder(new MatteBorder(0, 2, 0, 1, this.desktopIcon.getBackground()));
        this.desktopIcon.setLayout(new BorderLayout(2, 0));
        this.desktopIcon.add((Component)this.button, "Center");
        this.desktopIcon.add((Component)this.label, "West");
    }

    @Override
    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.label);
        this.desktopIcon.remove(this.button);
        this.button = null;
        this.frame = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.titleListener = new TitleListener();
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.titleListener);
    }

    @Override
    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.titleListener);
        this.titleListener = null;
        super.uninstallListeners();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    class TitleListener
    implements PropertyChangeListener {
        TitleListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("title")) {
                MetalDesktopIconUI.this.button.setText((String)e.getNewValue());
            }
            if (e.getPropertyName().equals("frameIcon")) {
                MetalDesktopIconUI.this.button.setIcon((Icon)e.getNewValue());
            }
        }
    }
}

