/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import javax.swing.UIDefaults;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.DefaultMetalTheme;

class MetalHighContrastTheme
extends DefaultMetalTheme {
    private static final ColorUIResource primary1 = new ColorUIResource(0, 0, 0);
    private static final ColorUIResource primary2 = new ColorUIResource(204, 204, 204);
    private static final ColorUIResource primary3 = new ColorUIResource(255, 255, 255);
    private static final ColorUIResource primaryHighlight = new ColorUIResource(102, 102, 102);
    private static final ColorUIResource secondary2 = new ColorUIResource(204, 204, 204);
    private static final ColorUIResource secondary3 = new ColorUIResource(255, 255, 255);
    private static final ColorUIResource controlHighlight = new ColorUIResource(102, 102, 102);

    MetalHighContrastTheme() {
    }

    @Override
    public String getName() {
        return "Contrast";
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return primary3;
    }

    @Override
    public ColorUIResource getPrimaryControlHighlight() {
        return primaryHighlight;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return secondary3;
    }

    @Override
    public ColorUIResource getControlHighlight() {
        return secondary2;
    }

    @Override
    public ColorUIResource getFocusColor() {
        return this.getBlack();
    }

    @Override
    public ColorUIResource getTextHighlightColor() {
        return this.getBlack();
    }

    @Override
    public ColorUIResource getHighlightedTextColor() {
        return this.getWhite();
    }

    @Override
    public ColorUIResource getMenuSelectedBackground() {
        return this.getBlack();
    }

    @Override
    public ColorUIResource getMenuSelectedForeground() {
        return this.getWhite();
    }

    @Override
    public ColorUIResource getAcceleratorForeground() {
        return this.getBlack();
    }

    @Override
    public ColorUIResource getAcceleratorSelectedForeground() {
        return this.getWhite();
    }

    @Override
    public void addCustomEntriesToTable(UIDefaults table) {
        BorderUIResource blackLineBorder = new BorderUIResource(new LineBorder(this.getBlack()));
        BorderUIResource whiteLineBorder = new BorderUIResource(new LineBorder(this.getWhite()));
        BorderUIResource textBorder = new BorderUIResource(new CompoundBorder(blackLineBorder, new BasicBorders.MarginBorder()));
        Object[] defaults = new Object[]{"ToolTip.border", blackLineBorder, "TitledBorder.border", blackLineBorder, "TextField.border", textBorder, "PasswordField.border", textBorder, "TextArea.border", textBorder, "TextPane.border", textBorder, "EditorPane.border", textBorder, "ComboBox.background", this.getWindowBackground(), "ComboBox.foreground", this.getUserTextColor(), "ComboBox.selectionBackground", this.getTextHighlightColor(), "ComboBox.selectionForeground", this.getHighlightedTextColor(), "ProgressBar.foreground", this.getUserTextColor(), "ProgressBar.background", this.getWindowBackground(), "ProgressBar.selectionForeground", this.getWindowBackground(), "ProgressBar.selectionBackground", this.getUserTextColor(), "OptionPane.errorDialog.border.background", this.getPrimary1(), "OptionPane.errorDialog.titlePane.foreground", this.getPrimary3(), "OptionPane.errorDialog.titlePane.background", this.getPrimary1(), "OptionPane.errorDialog.titlePane.shadow", this.getPrimary2(), "OptionPane.questionDialog.border.background", this.getPrimary1(), "OptionPane.questionDialog.titlePane.foreground", this.getPrimary3(), "OptionPane.questionDialog.titlePane.background", this.getPrimary1(), "OptionPane.questionDialog.titlePane.shadow", this.getPrimary2(), "OptionPane.warningDialog.border.background", this.getPrimary1(), "OptionPane.warningDialog.titlePane.foreground", this.getPrimary3(), "OptionPane.warningDialog.titlePane.background", this.getPrimary1(), "OptionPane.warningDialog.titlePane.shadow", this.getPrimary2()};
        table.putDefaults(defaults);
    }

    @Override
    boolean isSystemTheme() {
        return this.getClass() == MetalHighContrastTheme.class;
    }
}

