/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.spi.InputMethodDescriptor;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import sun.awt.im.AWTInputMethodPopupMenu;
import sun.awt.im.ExecutableInputMethodManager;
import sun.awt.im.InputMethodLocator;
import sun.awt.im.InputMethodManager;
import sun.awt.im.JInputMethodPopupMenu;

abstract class InputMethodPopupMenu
implements ActionListener {
    InputMethodPopupMenu() {
    }

    static InputMethodPopupMenu getInstance(Component client, String title) {
        if (client instanceof JFrame || client instanceof JDialog) {
            return new JInputMethodPopupMenu(title);
        }
        return new AWTInputMethodPopupMenu(title);
    }

    abstract void show(Component var1, int var2, int var3);

    abstract void removeAll();

    abstract void addSeparator();

    abstract void addToComponent(Component var1);

    abstract Object createSubmenu(String var1);

    abstract void add(Object var1);

    abstract void addMenuItem(String var1, String var2, String var3);

    abstract void addMenuItem(Object var1, String var2, String var3, String var4);

    void addOneInputMethodToMenu(InputMethodLocator locator, String currentSelection) {
        int localeCount;
        InputMethodDescriptor descriptor = locator.getDescriptor();
        String label = descriptor.getInputMethodDisplayName(null, Locale.getDefault());
        String command = locator.getActionCommandString();
        Locale[] locales = null;
        try {
            locales = descriptor.getAvailableLocales();
            localeCount = locales.length;
        }
        catch (AWTException e) {
            localeCount = 0;
        }
        if (localeCount == 0) {
            this.addMenuItem(label, null, currentSelection);
        } else if (localeCount == 1) {
            if (descriptor.hasDynamicLocaleList()) {
                label = descriptor.getInputMethodDisplayName(locales[0], Locale.getDefault());
                command = locator.deriveLocator(locales[0]).getActionCommandString();
            }
            this.addMenuItem(label, command, currentSelection);
        } else {
            Object submenu = this.createSubmenu(label);
            this.add(submenu);
            for (int j = 0; j < localeCount; ++j) {
                Locale locale = locales[j];
                String subLabel = this.getLocaleName(locale);
                String subCommand = locator.deriveLocator(locale).getActionCommandString();
                this.addMenuItem(submenu, subLabel, subCommand, currentSelection);
            }
        }
    }

    static boolean isSelected(String command, String currentSelection) {
        if (command == null || currentSelection == null) {
            return false;
        }
        if (command.equals(currentSelection)) {
            return true;
        }
        int index = currentSelection.indexOf(10);
        return index != -1 && currentSelection.substring(0, index).equals(command);
    }

    String getLocaleName(Locale locale) {
        String localeString = locale.toString();
        String localeName = Toolkit.getProperty("AWT.InputMethodLanguage." + localeString, null);
        if (localeName == null && ((localeName = locale.getDisplayName()) == null || localeName.length() == 0)) {
            localeName = localeString;
        }
        return localeName;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String choice = event.getActionCommand();
        ((ExecutableInputMethodManager)InputMethodManager.getInstance()).changeInputMethod(choice);
    }
}

