/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

final class EventDispatcher
implements Runnable {
    private static final int AUTO_CLOSE_TIME = 5000;
    private final ArrayList eventQueue = new ArrayList();
    private Thread thread = null;
    private final ArrayList<ClipInfo> autoClosingClips = new ArrayList();
    private final ArrayList<LineMonitor> lineMonitors = new ArrayList();
    static final int LINE_MONITOR_TIME = 400;

    EventDispatcher() {
    }

    synchronized void start() {
        if (this.thread == null) {
            this.thread = JSSecurityManager.createThread(this, "Java Sound Event Dispatcher", true, -1, true);
        }
    }

    void processEvent(EventInfo eventInfo) {
        int count = eventInfo.getListenerCount();
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent event = (LineEvent)eventInfo.getEvent();
            for (int i = 0; i < count; ++i) {
                try {
                    ((LineListener)eventInfo.getListener(i)).update(event);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage event = (MetaMessage)eventInfo.getEvent();
            for (int i = 0; i < count; ++i) {
                try {
                    ((MetaEventListener)eventInfo.getListener(i)).meta(event);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage event = (ShortMessage)eventInfo.getEvent();
            int status = event.getStatus();
            if ((status & 0xF0) == 176) {
                for (int i = 0; i < count; ++i) {
                    try {
                        ((ControllerEventListener)eventInfo.getListener(i)).controlChange(event);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                if (this.eventQueue.size() == 0) {
                    if (this.autoClosingClips.size() > 0 || this.lineMonitors.size() > 0) {
                        int waitTime = 5000;
                        if (this.lineMonitors.size() > 0) {
                            waitTime = 400;
                        }
                        this.wait(waitTime);
                    } else {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.eventQueue.size() > 0) {
                eventInfo = (EventInfo)this.eventQueue.remove(0);
            }
        }
        if (eventInfo != null) {
            this.processEvent(eventInfo);
        } else {
            if (this.autoClosingClips.size() > 0) {
                this.closeAutoClosingClips();
            }
            if (this.lineMonitors.size() > 0) {
                this.monitorLines();
            }
        }
    }

    private synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.add(eventInfo);
        this.notifyAll();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.dispatchEvents();
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    void sendAudioEvents(Object event, List listeners) {
        if (listeners == null || listeners.size() == 0) {
            return;
        }
        this.start();
        EventInfo eventInfo = new EventInfo(event, listeners);
        this.postEvent(eventInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAutoClosingClips() {
        ArrayList<ClipInfo> arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            long currTime = System.currentTimeMillis();
            for (int i = this.autoClosingClips.size() - 1; i >= 0; --i) {
                ClipInfo info = this.autoClosingClips.get(i);
                if (!info.isExpired(currTime)) continue;
                AutoClosingClip clip = info.getClip();
                if (!clip.isOpen() || !clip.isAutoClosing()) {
                    this.autoClosingClips.remove(i);
                    continue;
                }
                if (clip.isRunning() || clip.isActive() || !clip.isAutoClosing()) continue;
                clip.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAutoClosingClipIndex(AutoClosingClip clip) {
        ArrayList<ClipInfo> arrayList = this.autoClosingClips;
        synchronized (arrayList) {
            for (int i = this.autoClosingClips.size() - 1; i >= 0; --i) {
                if (!clip.equals(this.autoClosingClips.get(i).getClip())) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoClosingClipOpened(AutoClosingClip clip) {
        int index = 0;
        Object object = this.autoClosingClips;
        synchronized (object) {
            index = this.getAutoClosingClipIndex(clip);
            if (index == -1) {
                this.autoClosingClips.add(new ClipInfo(clip));
            }
        }
        if (index == -1) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    void autoClosingClipClosed(AutoClosingClip clip) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorLines() {
        ArrayList<LineMonitor> arrayList = this.lineMonitors;
        synchronized (arrayList) {
            for (int i = 0; i < this.lineMonitors.size(); ++i) {
                this.lineMonitors.get(i).checkLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLineMonitor(LineMonitor lm) {
        Object object = this.lineMonitors;
        synchronized (object) {
            if (this.lineMonitors.indexOf(lm) >= 0) {
                return;
            }
            this.lineMonitors.add(lm);
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLineMonitor(LineMonitor lm) {
        ArrayList<LineMonitor> arrayList = this.lineMonitors;
        synchronized (arrayList) {
            if (this.lineMonitors.indexOf(lm) < 0) {
                return;
            }
            this.lineMonitors.remove(lm);
        }
    }

    static interface LineMonitor {
        public void checkLine();
    }

    private class ClipInfo {
        private final AutoClosingClip clip;
        private final long expiration;

        ClipInfo(AutoClosingClip clip) {
            this.clip = clip;
            this.expiration = System.currentTimeMillis() + 5000L;
        }

        AutoClosingClip getClip() {
            return this.clip;
        }

        boolean isExpired(long currTime) {
            return currTime > this.expiration;
        }
    }

    private class EventInfo {
        private final Object event;
        private final Object[] listeners;

        EventInfo(Object event, List listeners) {
            this.event = event;
            this.listeners = listeners.toArray();
        }

        Object getEvent() {
            return this.event;
        }

        int getListenerCount() {
            return this.listeners.length;
        }

        Object getListener(int index) {
            return this.listeners[index];
        }
    }
}

