/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private final SelectorProvider provider;
    private SelectionKey[] keys = null;
    private int keyCount = 0;
    private final Object keyLock = new Object();
    private final Object regLock = new Object();
    boolean blocking = true;

    protected AbstractSelectableChannel(SelectorProvider provider) {
        this.provider = provider;
    }

    @Override
    public final SelectorProvider provider() {
        return this.provider;
    }

    private void addKey(SelectionKey k) {
        assert (Thread.holdsLock(this.keyLock));
        int i = 0;
        if (this.keys != null && this.keyCount < this.keys.length) {
            for (i = 0; i < this.keys.length && this.keys[i] != null; ++i) {
            }
        } else if (this.keys == null) {
            this.keys = new SelectionKey[3];
        } else {
            int n = this.keys.length * 2;
            SelectionKey[] ks = new SelectionKey[n];
            for (i = 0; i < this.keys.length; ++i) {
                ks[i] = this.keys[i];
            }
            this.keys = ks;
            i = this.keyCount;
        }
        this.keys[i] = k;
        ++this.keyCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectionKey findKey(Selector sel) {
        Object object = this.keyLock;
        synchronized (object) {
            if (this.keys == null) {
                return null;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null || this.keys[i].selector() != sel) continue;
                return this.keys[i];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeKey(SelectionKey k) {
        Object object = this.keyLock;
        synchronized (object) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != k) continue;
                this.keys[i] = null;
                --this.keyCount;
            }
            ((AbstractSelectionKey)k).invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveValidKeys() {
        Object object = this.keyLock;
        synchronized (object) {
            if (this.keyCount == 0) {
                return false;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null || !this.keys[i].isValid()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isRegistered() {
        Object object = this.keyLock;
        synchronized (object) {
            return this.keyCount != 0;
        }
    }

    @Override
    public final SelectionKey keyFor(Selector sel) {
        return this.findKey(sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SelectionKey register(Selector sel, int ops, Object att) throws ClosedChannelException {
        Object object = this.regLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if ((ops & ~this.validOps()) != 0) {
                throw new IllegalArgumentException();
            }
            if (this.blocking) {
                throw new IllegalBlockingModeException();
            }
            SelectionKey k = this.findKey(sel);
            if (k != null) {
                k.interestOps(ops);
                k.attach(att);
            }
            if (k == null) {
                Object object2 = this.keyLock;
                synchronized (object2) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    k = ((AbstractSelector)sel).register(this, ops, att);
                    this.addKey(k);
                }
            }
            return k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
        Object object = this.keyLock;
        synchronized (object) {
            int count = this.keys == null ? 0 : this.keys.length;
            for (int i = 0; i < count; ++i) {
                SelectionKey k = this.keys[i];
                if (k == null) continue;
                k.cancel();
            }
        }
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isBlocking() {
        Object object = this.regLock;
        synchronized (object) {
            return this.blocking;
        }
    }

    @Override
    public final Object blockingLock() {
        return this.regLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SelectableChannel configureBlocking(boolean block) throws IOException {
        Object object = this.regLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.blocking == block) {
                return this;
            }
            if (block && this.haveValidKeys()) {
                throw new IllegalBlockingModeException();
            }
            this.implConfigureBlocking(block);
            this.blocking = block;
        }
        return this;
    }

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;
}

