/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.URLJarFileCallBack;

public class URLJarFile
extends JarFile {
    private static URLJarFileCallBack callback = null;
    private URLJarFileCloseController closeController = null;
    private static int BUF_SIZE = 2048;
    private Manifest superMan;
    private Attributes superAttr;
    private Map<String, Attributes> superEntries;

    static JarFile getJarFile(URL url) throws IOException {
        return URLJarFile.getJarFile(url, null);
    }

    static JarFile getJarFile(URL url, URLJarFileCloseController closeController) throws IOException {
        if (URLJarFile.isFileURL(url)) {
            return new URLJarFile(url, closeController);
        }
        return URLJarFile.retrieve(url, closeController);
    }

    public URLJarFile(File file) throws IOException {
        this(file, (URLJarFileCloseController)null);
    }

    public URLJarFile(File file, URLJarFileCloseController closeController) throws IOException {
        super(file, true, 5);
        this.closeController = closeController;
    }

    private URLJarFile(URL url, URLJarFileCloseController closeController) throws IOException {
        super(ParseUtil.decode(url.getFile()));
        this.closeController = closeController;
    }

    private static boolean isFileURL(URL url) {
        String host;
        return url.getProtocol().equalsIgnoreCase("file") && ((host = url.getHost()) == null || host.equals("") || host.equals("~") || host.equalsIgnoreCase("localhost"));
    }

    @Override
    protected void finalize() throws IOException {
        this.close();
    }

    @Override
    public ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        if (ze != null) {
            if (ze instanceof JarEntry) {
                return new URLJarFileEntry((JarEntry)ze);
            }
            throw new InternalError(super.getClass() + " returned unexpected entry type " + ze.getClass());
        }
        return null;
    }

    @Override
    public Manifest getManifest() throws IOException {
        if (!this.isSuperMan()) {
            return null;
        }
        Manifest man = new Manifest();
        Attributes attr = man.getMainAttributes();
        attr.putAll((Map<?, ?>)((Map)this.superAttr.clone()));
        if (this.superEntries != null) {
            Map<String, Attributes> entries = man.getEntries();
            for (String key : this.superEntries.keySet()) {
                Attributes at = this.superEntries.get(key);
                entries.put(key, (Attributes)at.clone());
            }
        }
        return man;
    }

    @Override
    public void close() throws IOException {
        if (this.closeController != null) {
            this.closeController.close(this);
        }
        super.close();
    }

    private synchronized boolean isSuperMan() throws IOException {
        if (this.superMan == null) {
            this.superMan = super.getManifest();
        }
        if (this.superMan != null) {
            this.superAttr = this.superMan.getMainAttributes();
            this.superEntries = this.superMan.getEntries();
            return true;
        }
        return false;
    }

    private static JarFile retrieve(URL url) throws IOException {
        return URLJarFile.retrieve(url, null);
    }

    private static JarFile retrieve(URL url, final URLJarFileCloseController closeController) throws IOException {
        if (callback != null) {
            return callback.retrieve(url);
        }
        JarFile result = null;
        try (final InputStream in = url.openConnection().getInputStream();){
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws IOException {
                    Path tmpFile = Files.createTempFile("jar_cache", null, new FileAttribute[0]);
                    try {
                        Files.copy(in, tmpFile, StandardCopyOption.REPLACE_EXISTING);
                        URLJarFile jarFile = new URLJarFile(tmpFile.toFile(), closeController);
                        tmpFile.toFile().deleteOnExit();
                        return jarFile;
                    }
                    catch (Throwable thr) {
                        try {
                            Files.delete(tmpFile);
                        }
                        catch (IOException ioe) {
                            thr.addSuppressed(ioe);
                        }
                        throw thr;
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        return result;
    }

    public static void setCallBack(URLJarFileCallBack cb) {
        callback = cb;
    }

    public static interface URLJarFileCloseController {
        public void close(JarFile var1);
    }

    private class URLJarFileEntry
    extends JarEntry {
        private JarEntry je;

        URLJarFileEntry(JarEntry je) {
            super(je);
            this.je = je;
        }

        @Override
        public Attributes getAttributes() throws IOException {
            Attributes a;
            Map e;
            if (URLJarFile.this.isSuperMan() && (e = URLJarFile.this.superEntries) != null && (a = (Attributes)e.get(this.getName())) != null) {
                return (Attributes)a.clone();
            }
            return null;
        }

        @Override
        public Certificate[] getCertificates() {
            Certificate[] certs = this.je.getCertificates();
            return certs == null ? null : (Certificate[])certs.clone();
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            CodeSigner[] csg = this.je.getCodeSigners();
            return csg == null ? null : (CodeSigner[])csg.clone();
        }
    }
}

