/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.login;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;

public class ConfigFile
extends Configuration {
    private StreamTokenizer st;
    private int lookahead;
    private int linenum;
    private HashMap<String, LinkedList<AppConfigurationEntry>> configuration;
    private boolean expandProp = true;
    private URL url;
    private static Debug debugConfig = Debug.getInstance("configfile");
    private static Debug debugParser = Debug.getInstance("configparser");

    public ConfigFile() {
        try {
            this.init(this.url);
        }
        catch (IOException ioe) {
            throw (SecurityException)new SecurityException(ioe.getMessage()).initCause(ioe);
        }
    }

    public ConfigFile(URI uri) {
        try {
            this.url = uri.toURL();
            this.init(this.url);
        }
        catch (MalformedURLException mue) {
            throw (SecurityException)new SecurityException(mue.getMessage()).initCause(mue);
        }
        catch (IOException ioe) {
            throw (SecurityException)new SecurityException(ioe.getMessage()).initCause(ioe);
        }
    }

    private void init(URL url) throws IOException {
        String config_url;
        String extra_config;
        boolean initialized = false;
        Object fr = null;
        String sep = File.separator;
        if ("false".equals(System.getProperty("policy.expandProperties"))) {
            this.expandProp = false;
        }
        HashMap<String, LinkedList<AppConfigurationEntry>> newConfig = new HashMap<String, LinkedList<AppConfigurationEntry>>();
        if (url != null) {
            if (debugConfig != null) {
                debugConfig.println("reading " + url);
            }
            this.init(url, newConfig);
            this.configuration = newConfig;
            return;
        }
        String allowSys = Security.getProperty("policy.allowSystemProperty");
        if ("true".equalsIgnoreCase(allowSys) && (extra_config = System.getProperty("java.security.auth.login.config")) != null) {
            boolean overrideAll = false;
            if (extra_config.startsWith("=")) {
                overrideAll = true;
                extra_config = extra_config.substring(1);
            }
            try {
                extra_config = PropertyExpander.expand(extra_config);
            }
            catch (PropertyExpander.ExpandException peee) {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Unable.to.properly.expand.config", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{extra_config};
                throw new IOException(form.format(source));
            }
            URL configURL = null;
            try {
                configURL = new URL(extra_config);
            }
            catch (MalformedURLException mue) {
                File configFile = new File(extra_config);
                if (configFile.exists()) {
                    configURL = configFile.toURI().toURL();
                }
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("extra.config.No.such.file.or.directory.", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{extra_config};
                throw new IOException(form.format(source));
            }
            if (debugConfig != null) {
                debugConfig.println("reading " + configURL);
            }
            this.init(configURL, newConfig);
            initialized = true;
            if (overrideAll) {
                if (debugConfig != null) {
                    debugConfig.println("overriding other policies!");
                }
                this.configuration = newConfig;
                return;
            }
        }
        int n = 1;
        while ((config_url = Security.getProperty("login.config.url." + n)) != null) {
            try {
                config_url = PropertyExpander.expand(config_url).replace(File.separatorChar, '/');
                if (debugConfig != null) {
                    debugConfig.println("\tReading config: " + config_url);
                }
                this.init(new URL(config_url), newConfig);
                initialized = true;
            }
            catch (PropertyExpander.ExpandException peee) {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Unable.to.properly.expand.config", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{config_url};
                throw new IOException(form.format(source));
            }
            ++n;
        }
        if (!initialized && n == 1 && config_url == null) {
            String userConfigFile;
            if (debugConfig != null) {
                debugConfig.println("\tReading Policy from ~/.java.login.config");
            }
            if (new File(userConfigFile = (config_url = System.getProperty("user.home")) + File.separatorChar + ".java.login.config").exists()) {
                this.init(new File(userConfigFile).toURI().toURL(), newConfig);
            }
        }
        this.configuration = newConfig;
    }

    private void init(URL config, HashMap<String, LinkedList<AppConfigurationEntry>> newConfig) throws IOException {
        try (InputStreamReader isr = null;){
            isr = new InputStreamReader(this.getInputStream(config), "UTF-8");
            this.readConfig(isr, newConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        LinkedList<AppConfigurationEntry> list = null;
        HashMap<String, LinkedList<AppConfigurationEntry>> hashMap = this.configuration;
        synchronized (hashMap) {
            list = this.configuration.get(applicationName);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        AppConfigurationEntry[] entries = new AppConfigurationEntry[list.size()];
        Iterator iterator = list.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            AppConfigurationEntry e = (AppConfigurationEntry)iterator.next();
            entries[i] = new AppConfigurationEntry(e.getLoginModuleName(), e.getControlFlag(), e.getOptions());
            ++i;
        }
        return entries;
    }

    @Override
    public synchronized void refresh() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("refreshLoginConfiguration"));
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    ConfigFile.this.init(ConfigFile.this.url);
                }
                catch (IOException ioe) {
                    throw (SecurityException)new SecurityException(ioe.getLocalizedMessage()).initCause(ioe);
                }
                return null;
            }
        });
    }

    private void readConfig(Reader reader, HashMap<String, LinkedList<AppConfigurationEntry>> newConfig) throws IOException {
        boolean linenum = true;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.quoteChar(34);
        this.st.wordChars(36, 36);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.eolIsSignificant(true);
        this.lookahead = this.nextToken();
        while (this.lookahead != -1) {
            this.parseLoginEntry(newConfig);
        }
    }

    private void parseLoginEntry(HashMap<String, LinkedList<AppConfigurationEntry>> newConfig) throws IOException {
        Object[] source;
        MessageFormat form;
        LinkedList<AppConfigurationEntry> configEntries = new LinkedList<AppConfigurationEntry>();
        String appName = this.st.sval;
        this.lookahead = this.nextToken();
        if (debugParser != null) {
            debugParser.println("\tReading next config entry: " + appName);
        }
        this.match("{");
        while (!this.peek("}")) {
            AppConfigurationEntry.LoginModuleControlFlag controlFlag;
            String moduleClass = this.match("module class name");
            String sflag = this.match("controlFlag");
            if (sflag.equalsIgnoreCase("REQUIRED")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (sflag.equalsIgnoreCase("REQUISITE")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (sflag.equalsIgnoreCase("SUFFICIENT")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (sflag.equalsIgnoreCase("OPTIONAL")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else {
                form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Invalid.control.flag.flag", "sun.security.util.AuthResources"));
                source = new Object[]{sflag};
                throw new IOException(form.format(source));
            }
            HashMap<String, String> options = new HashMap<String, String>();
            while (!this.peek(";")) {
                String value;
                String key = this.match("option key");
                this.match("=");
                try {
                    value = this.expand(this.match("option value"));
                }
                catch (PropertyExpander.ExpandException peee) {
                    throw new IOException(peee.getLocalizedMessage());
                }
                options.put(key, value);
            }
            this.lookahead = this.nextToken();
            if (debugParser != null) {
                debugParser.println("\t\t" + moduleClass + ", " + sflag);
                for (String key : options.keySet()) {
                    debugParser.println("\t\t\t" + key + "=" + (String)options.get(key));
                }
            }
            AppConfigurationEntry entry = new AppConfigurationEntry(moduleClass, controlFlag, options);
            configEntries.add(entry);
        }
        this.match("}");
        this.match(";");
        if (newConfig.containsKey(appName)) {
            form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Can.not.specify.multiple.entries.for.appName", "sun.security.util.AuthResources"));
            source = new Object[]{appName};
            throw new IOException(form.format(source));
        }
        newConfig.put(appName, configEntries);
    }

    private String match(String expect) throws IOException {
        String value = null;
        switch (this.lookahead) {
            case -1: {
                MessageFormat form1 = new MessageFormat(ResourcesMgr.getString("Configuration.Error.expected.expect.read.end.of.file.", "sun.security.util.AuthResources"));
                Object[] source1 = new Object[]{expect};
                throw new IOException(form1.format(source1));
            }
            case -3: 
            case 34: {
                if (expect.equalsIgnoreCase("module class name") || expect.equalsIgnoreCase("controlFlag") || expect.equalsIgnoreCase("option key") || expect.equalsIgnoreCase("option value")) {
                    value = this.st.sval;
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Line.line.expected.expect.found.value.", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{new Integer(this.linenum), expect, this.st.sval};
                throw new IOException(form.format(source));
            }
            case 123: {
                if (expect.equalsIgnoreCase("{")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Line.line.expected.expect.", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{new Integer(this.linenum), expect, this.st.sval};
                throw new IOException(form.format(source));
            }
            case 59: {
                if (expect.equalsIgnoreCase(";")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Line.line.expected.expect.", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{new Integer(this.linenum), expect, this.st.sval};
                throw new IOException(form.format(source));
            }
            case 125: {
                if (expect.equalsIgnoreCase("}")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Line.line.expected.expect.", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{new Integer(this.linenum), expect, this.st.sval};
                throw new IOException(form.format(source));
            }
            case 61: {
                if (expect.equalsIgnoreCase("=")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Line.line.expected.expect.", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{new Integer(this.linenum), expect, this.st.sval};
                throw new IOException(form.format(source));
            }
            default: {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Line.line.expected.expect.found.value.", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{new Integer(this.linenum), expect, this.st.sval};
                throw new IOException(form.format(source));
            }
        }
        return value;
    }

    private boolean peek(String expect) {
        boolean found = false;
        switch (this.lookahead) {
            case 44: {
                if (!expect.equalsIgnoreCase(",")) break;
                found = true;
                break;
            }
            case 59: {
                if (!expect.equalsIgnoreCase(";")) break;
                found = true;
                break;
            }
            case 123: {
                if (!expect.equalsIgnoreCase("{")) break;
                found = true;
                break;
            }
            case 125: {
                if (!expect.equalsIgnoreCase("}")) break;
                found = true;
                break;
            }
        }
        return found;
    }

    private int nextToken() throws IOException {
        int tok;
        while ((tok = this.st.nextToken()) == 10) {
            ++this.linenum;
        }
        return tok;
    }

    private InputStream getInputStream(URL url) throws IOException {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                return url.openStream();
            }
            catch (Exception e) {
                String file = url.getPath();
                if (url.getHost().length() > 0) {
                    file = "//" + url.getHost() + file;
                }
                if (debugConfig != null) {
                    debugConfig.println("cannot read " + url + ", try " + file);
                }
                return new FileInputStream(file);
            }
        }
        return url.openStream();
    }

    private String expand(String value) throws PropertyExpander.ExpandException, IOException {
        if ("".equals(value)) {
            return value;
        }
        if (this.expandProp) {
            String s = PropertyExpander.expand(value);
            if (s == null || s.length() == 0) {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("Configuration.Error.Line.line.system.property.value.expanded.to.empty.value", "sun.security.util.AuthResources"));
                Object[] source = new Object[]{new Integer(this.linenum), value};
                throw new IOException(form.format(source));
            }
            return s;
        }
        return value;
    }
}

