/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.ListIterator;

public class ImageCache {
    private int maxCount;
    private final LinkedList<SoftReference<Entry>> entries;

    public ImageCache(int maxCount) {
        this.maxCount = maxCount;
        this.entries = new LinkedList();
    }

    void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void flush() {
        this.entries.clear();
    }

    private Entry getEntry(Object key, GraphicsConfiguration config, int w, int h, Object[] args) {
        Entry entry;
        ListIterator iter = this.entries.listIterator();
        while (iter.hasNext()) {
            SoftReference ref = (SoftReference)iter.next();
            entry = (Entry)ref.get();
            if (entry == null) {
                iter.remove();
                continue;
            }
            if (!entry.equals(config, w, h, args)) continue;
            iter.remove();
            this.entries.addFirst(ref);
            return entry;
        }
        entry = new Entry(config, w, h, args);
        if (this.entries.size() >= this.maxCount) {
            this.entries.removeLast();
        }
        this.entries.addFirst(new SoftReference<Entry>(entry));
        return entry;
    }

    public Image getImage(Object key, GraphicsConfiguration config, int w, int h, Object[] args) {
        Entry entry = this.getEntry(key, config, w, h, args);
        return entry.getImage();
    }

    public void setImage(Object key, GraphicsConfiguration config, int w, int h, Object[] args, Image image) {
        Entry entry = this.getEntry(key, config, w, h, args);
        entry.setImage(image);
    }

    private static class Entry {
        private final GraphicsConfiguration config;
        private final int w;
        private final int h;
        private final Object[] args;
        private Image image;

        Entry(GraphicsConfiguration config, int w, int h, Object[] args) {
            this.config = config;
            this.args = args;
            this.w = w;
            this.h = h;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public Image getImage() {
            return this.image;
        }

        public String toString() {
            String value = super.toString() + "[ graphicsConfig=" + this.config + ", image=" + this.image + ", w=" + this.w + ", h=" + this.h;
            if (this.args != null) {
                for (int counter = 0; counter < this.args.length; ++counter) {
                    value = value + ", " + this.args[counter];
                }
            }
            value = value + "]";
            return value;
        }

        public boolean equals(GraphicsConfiguration config, int w, int h, Object[] args) {
            if (this.w == w && this.h == h && (this.config != null && this.config.equals(config) || this.config == null && config == null)) {
                if (this.args == null && args == null) {
                    return true;
                }
                if (this.args != null && args != null && this.args.length == args.length) {
                    for (int counter = args.length - 1; counter >= 0; --counter) {
                        Object a1 = this.args[counter];
                        Object a2 = args[counter];
                        if ((a1 != null || a2 == null) && (a1 == null || a1.equals(a2))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

