/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Extension;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public class TSRequest {
    private int version = 1;
    private AlgorithmId hashAlgorithmId = null;
    private byte[] hashValue;
    private String policyId = null;
    private BigInteger nonce = null;
    private boolean returnCertificate = false;
    private X509Extension[] extensions = null;

    public TSRequest(String tSAPolicyID, byte[] toBeTimeStamped, MessageDigest messageDigest) throws NoSuchAlgorithmException {
        this.policyId = tSAPolicyID;
        this.hashAlgorithmId = AlgorithmId.get(messageDigest.getAlgorithm());
        this.hashValue = messageDigest.digest(toBeTimeStamped);
    }

    public byte[] getHashedMessage() {
        return (byte[])this.hashValue.clone();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public void requestCertificate(boolean returnCertificate) {
        this.returnCertificate = returnCertificate;
    }

    public void setExtensions(X509Extension[] extensions) {
        this.extensions = extensions;
    }

    public byte[] encode() throws IOException {
        DerOutputStream request = new DerOutputStream();
        request.putInteger(this.version);
        DerOutputStream messageImprint = new DerOutputStream();
        this.hashAlgorithmId.encode(messageImprint);
        messageImprint.putOctetString(this.hashValue);
        request.write((byte)48, messageImprint);
        if (this.policyId != null) {
            request.putOID(new ObjectIdentifier(this.policyId));
        }
        if (this.nonce != null) {
            request.putInteger(this.nonce);
        }
        if (this.returnCertificate) {
            request.putBoolean(true);
        }
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, request);
        return out.toByteArray();
    }
}

