/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XCheckboxMenuItemPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XToolkit;
import sun.util.logging.PlatformLogger;

public class XMenuWindow
extends XBaseMenuWindow {
    private static PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XMenuWindow");
    private XMenuPeer menuPeer;
    private static final int WINDOW_SPACING_LEFT = 2;
    private static final int WINDOW_SPACING_RIGHT = 2;
    private static final int WINDOW_SPACING_TOP = 2;
    private static final int WINDOW_SPACING_BOTTOM = 2;
    private static final int WINDOW_ITEM_INDENT = 15;
    private static final int WINDOW_ITEM_MARGIN_LEFT = 2;
    private static final int WINDOW_ITEM_MARGIN_RIGHT = 2;
    private static final int WINDOW_ITEM_MARGIN_TOP = 2;
    private static final int WINDOW_ITEM_MARGIN_BOTTOM = 2;
    private static final int WINDOW_SHORTCUT_SPACING = 10;
    private static final int CHECKMARK_SIZE = 128;
    private static final int[] CHECKMARK_X = new int[]{1, 25, 56, 124, 124, 85, 64};
    private static final int[] CHECKMARK_Y = new int[]{59, 35, 67, 0, 12, 66, 123};

    XMenuWindow(XMenuPeer menuPeer) {
        if (menuPeer != null) {
            this.menuPeer = menuPeer;
            this.target = menuPeer.getContainer().target;
            Vector targetItemVector = null;
            targetItemVector = this.getMenuTargetItems();
            this.reloadItems(targetItemVector);
        }
    }

    @Override
    void postInit(XCreateWindowParams params) {
        super.postInit(params);
    }

    @Override
    protected XBaseMenuWindow getParentMenuWindow() {
        return this.menuPeer != null ? this.menuPeer.getContainer() : null;
    }

    @Override
    protected MappingData map() {
        if (!this.isCreated()) {
            MappingData mappingData = new MappingData(new XMenuItemPeer[0], new Rectangle(0, 0, 0, 0), new Dimension(0, 0), 0, 0, 0);
            return mappingData;
        }
        XMenuItemPeer[] itemVector = this.copyItems();
        int itemCnt = itemVector.length;
        Dimension captionSize = this.getCaptionSize();
        int maxWidth = captionSize != null ? captionSize.width : 0;
        int maxLeftIndent = 0;
        int maxRightIndent = 0;
        int maxShortcutWidth = 0;
        XMenuItemPeer.TextMetrics[] itemMetrics = new XMenuItemPeer.TextMetrics[itemCnt];
        for (int i = 0; i < itemCnt; ++i) {
            XMenuItemPeer item = itemVector[i];
            itemMetrics[i] = itemVector[i].getTextMetrics();
            Dimension dim = itemMetrics[i].getTextDimension();
            if (dim == null) continue;
            if (itemVector[i] instanceof XCheckboxMenuItemPeer) {
                maxLeftIndent = Math.max(maxLeftIndent, dim.height);
            } else if (itemVector[i] instanceof XMenuPeer) {
                maxRightIndent = Math.max(maxRightIndent, dim.height);
            }
            maxWidth = Math.max(maxWidth, dim.width);
            maxShortcutWidth = Math.max(maxShortcutWidth, itemMetrics[i].getShortcutWidth());
        }
        int nextOffset = 2;
        int shortcutOrigin = 4 + maxLeftIndent + maxWidth;
        if (maxShortcutWidth > 0) {
            shortcutOrigin += 10;
        }
        int rightMarkOrigin = shortcutOrigin + maxShortcutWidth;
        int itemWidth = rightMarkOrigin + maxRightIndent + 2;
        int width = 2 + itemWidth + 2;
        Rectangle captionRect = null;
        if (captionSize != null) {
            captionRect = new Rectangle(2, nextOffset, itemWidth, captionSize.height);
            nextOffset += captionSize.height;
        } else {
            captionRect = new Rectangle(2, nextOffset, maxWidth, 0);
        }
        for (int i = 0; i < itemCnt; ++i) {
            XMenuItemPeer item = itemVector[i];
            XMenuItemPeer.TextMetrics metrics = itemMetrics[i];
            Dimension dim = metrics.getTextDimension();
            if (dim != null) {
                int itemHeight = 2 + dim.height + 2;
                Rectangle bounds = new Rectangle(2, nextOffset, itemWidth, itemHeight);
                int y = (itemHeight + dim.height) / 2 - metrics.getTextBaseline();
                Point textOrigin = new Point(4 + maxLeftIndent, nextOffset + y);
                nextOffset += itemHeight;
                item.map(bounds, textOrigin);
                continue;
            }
            Rectangle bounds = new Rectangle(2, nextOffset, 0, 0);
            Point textOrigin = new Point(4 + maxLeftIndent, nextOffset);
            item.map(bounds, textOrigin);
        }
        int height = nextOffset + 2;
        MappingData mappingData = new MappingData(itemVector, captionRect, new Dimension(width, height), maxLeftIndent, shortcutOrigin, rightMarkOrigin);
        return mappingData;
    }

    @Override
    protected Rectangle getSubmenuBounds(Rectangle itemBounds, Dimension windowSize) {
        Dimension screenSize;
        Rectangle globalBounds = this.toGlobal(itemBounds);
        Rectangle res = this.fitWindowRight(globalBounds, windowSize, screenSize = Toolkit.getDefaultToolkit().getScreenSize());
        if (res != null) {
            return res;
        }
        res = this.fitWindowBelow(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowAbove(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowLeft(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        return this.fitWindowToScreen(windowSize, screenSize);
    }

    @Override
    protected void updateSize() {
        this.resetMapping();
        if (this.isShowing()) {
            XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                @Override
                public void run() {
                    Dimension dim = XMenuWindow.this.getDesiredSize();
                    XMenuWindow.this.reshape(XMenuWindow.this.x, XMenuWindow.this.y, dim.width, dim.height);
                }
            });
        }
    }

    protected Dimension getCaptionSize() {
        return null;
    }

    protected void paintCaption(Graphics g, Rectangle rect) {
    }

    XMenuPeer getMenuPeer() {
        return this.menuPeer;
    }

    Vector getMenuTargetItems() {
        return this.menuPeer.getTargetItems();
    }

    Dimension getDesiredSize() {
        MappingData mappingData = (MappingData)this.getMappingData();
        return mappingData.getDesiredSize();
    }

    boolean isCreated() {
        return this.getWindow() != 0L;
    }

    boolean ensureCreated() {
        if (!this.isCreated()) {
            XCreateWindowParams params = this.getDelayedParams();
            params.remove("delayed");
            params.add((Object)"overrideRedirect", Boolean.TRUE);
            params.add((Object)"target", this.target);
            this.init(params);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void show(Rectangle bounds) {
        if (!this.isCreated()) {
            return;
        }
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("showing menu window + " + this.getWindow() + " at " + bounds);
        }
        XToolkit.awtLock();
        try {
            this.reshape(bounds.x, bounds.y, bounds.width, bounds.height);
            this.xSetVisible(true);
            this.toFront();
            this.selectItem(this.getFirstSelectableItem(), false);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void hide() {
        this.selectItem(null, false);
        this.xSetVisible(false);
    }

    @Override
    public void paint(Graphics g) {
        this.resetColors();
        int width = this.getWidth();
        int height = this.getHeight();
        this.flush();
        g.setColor(this.getBackgroundColor());
        g.fillRect(1, 1, width - 2, height - 2);
        this.draw3DRect(g, 0, 0, width, height, true);
        MappingData mappingData = (MappingData)this.getMappingData();
        this.paintCaption(g, mappingData.getCaptionRect());
        XMenuItemPeer[] itemVector = mappingData.getItems();
        Dimension windowSize = mappingData.getDesiredSize();
        XMenuItemPeer selectedItem = this.getSelectedItem();
        for (int i = 0; i < itemVector.length; ++i) {
            int markY;
            int markX;
            int markHeight;
            int markWidth;
            XMenuItemPeer item = itemVector[i];
            XMenuItemPeer.TextMetrics metrics = item.getTextMetrics();
            Rectangle bounds = item.getBounds();
            if (item.isSeparator()) {
                this.draw3DRect(g, bounds.x, bounds.y + bounds.height / 2, bounds.width, 2, false);
                continue;
            }
            g.setFont(item.getTargetFont());
            Point textOrigin = item.getTextOrigin();
            Dimension textDim = metrics.getTextDimension();
            if (item == selectedItem) {
                g.setColor(this.getSelectedColor());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                this.draw3DRect(g, bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
            g.setColor(item.isTargetItemEnabled() ? this.getForegroundColor() : this.getDisabledColor());
            g.drawString(item.getTargetLabel(), textOrigin.x, textOrigin.y);
            String shortcutText = item.getShortcutText();
            if (shortcutText != null) {
                g.drawString(shortcutText, mappingData.getShortcutOrigin(), textOrigin.y);
            }
            if (item instanceof XMenuPeer) {
                markWidth = textDim.height * 4 / 5;
                markHeight = textDim.height * 4 / 5;
                markX = bounds.x + bounds.width - markWidth - 2 - 2;
                markY = bounds.y + (bounds.height - markHeight) / 2;
                g.setColor(item.isTargetItemEnabled() ? this.getDarkShadowColor() : this.getDisabledColor());
                g.drawLine(markX, markY + markHeight, markX + markWidth, markY + markHeight / 2);
                g.setColor(item.isTargetItemEnabled() ? this.getLightShadowColor() : this.getDisabledColor());
                g.drawLine(markX, markY, markX + markWidth, markY + markHeight / 2);
                g.drawLine(markX, markY, markX, markY + markHeight);
                continue;
            }
            if (!(item instanceof XCheckboxMenuItemPeer)) continue;
            markWidth = textDim.height * 4 / 5;
            markHeight = textDim.height * 4 / 5;
            markX = 4;
            markY = bounds.y + (bounds.height - markHeight) / 2;
            boolean checkState = ((XCheckboxMenuItemPeer)item).getTargetState();
            if (checkState) {
                g.setColor(this.getSelectedColor());
                g.fillRect(markX, markY, markWidth, markHeight);
                this.draw3DRect(g, markX, markY, markWidth, markHeight, false);
                int[] px = new int[CHECKMARK_X.length];
                int[] py = new int[CHECKMARK_X.length];
                for (int j = 0; j < CHECKMARK_X.length; ++j) {
                    px[j] = markX + CHECKMARK_X[j] * markWidth / 128;
                    py[j] = markY + CHECKMARK_Y[j] * markHeight / 128;
                }
                g.setColor(item.isTargetItemEnabled() ? this.getForegroundColor() : this.getDisabledColor());
                g.fillPolygon(px, py, CHECKMARK_X.length);
                continue;
            }
            g.setColor(this.getBackgroundColor());
            g.fillRect(markX, markY, markWidth, markHeight);
            this.draw3DRect(g, markX, markY, markWidth, markHeight, true);
        }
        this.flush();
    }

    static class MappingData
    extends XBaseMenuWindow.MappingData {
        private Rectangle captionRect;
        private Dimension desiredSize;
        private int leftMarkWidth;
        private int shortcutOrigin;
        private int rightMarkOrigin;

        MappingData(XMenuItemPeer[] items, Rectangle captionRect, Dimension desiredSize, int leftMarkWidth, int shortcutOrigin, int rightMarkOrigin) {
            super(items);
            this.captionRect = captionRect;
            this.desiredSize = desiredSize;
            this.leftMarkWidth = leftMarkWidth;
            this.shortcutOrigin = shortcutOrigin;
            this.rightMarkOrigin = rightMarkOrigin;
        }

        MappingData() {
            this.desiredSize = new Dimension(0, 0);
            this.leftMarkWidth = 0;
            this.shortcutOrigin = 0;
            this.rightMarkOrigin = 0;
        }

        public Rectangle getCaptionRect() {
            return this.captionRect;
        }

        public Dimension getDesiredSize() {
            return this.desiredSize;
        }

        public int getShortcutOrigin() {
            return this.shortcutOrigin;
        }

        public int getLeftMarkWidth() {
            return this.leftMarkWidth;
        }

        public int getRightMarkOrigin() {
            return this.rightMarkOrigin;
        }
    }
}

