/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import sun.management.AgentConfigurationError;
import sun.management.ConnectorAddressLink;
import sun.management.jdp.JdpController;
import sun.management.jdp.JdpException;
import sun.management.jmxremote.ConnectorBootstrap;
import sun.misc.VMSupport;

public class Agent {
    private static Properties mgmtProps;
    private static ResourceBundle messageRB;
    private static final String CONFIG_FILE = "com.sun.management.config.file";
    private static final String SNMP_PORT = "com.sun.management.snmp.port";
    private static final String JMXREMOTE = "com.sun.management.jmxremote";
    private static final String JMXREMOTE_PORT = "com.sun.management.jmxremote.port";
    private static final String RMI_PORT = "com.sun.management.jmxremote.rmi.port";
    private static final String ENABLE_THREAD_CONTENTION_MONITORING = "com.sun.management.enableThreadContentionMonitoring";
    private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String SNMP_ADAPTOR_BOOTSTRAP_CLASS_NAME = "sun.management.snmp.AdaptorBootstrap";
    private static final String JDP_DEFAULT_ADDRESS = "224.0.23.178";
    private static final int JDP_DEFAULT_PORT = 7095;
    private static JMXConnectorServer jmxServer;

    private static Properties parseString(String args) {
        Properties argProps = new Properties();
        if (args != null) {
            for (String option : args.split(",")) {
                String value;
                String[] s = option.split("=", 2);
                String name = s[0].trim();
                String string = value = s.length > 1 ? s[1].trim() : "";
                if (!name.startsWith("com.sun.management.")) {
                    Agent.error("agent.err.invalid.option", name);
                }
                argProps.setProperty(name, value);
            }
        }
        return argProps;
    }

    public static void premain(String args) throws Exception {
        Agent.agentmain(args);
    }

    public static void agentmain(String args) throws Exception {
        if (args == null || args.length() == 0) {
            args = JMXREMOTE;
        }
        Properties arg_props = Agent.parseString(args);
        Properties config_props = new Properties();
        String fname = arg_props.getProperty(CONFIG_FILE);
        Agent.readConfiguration(fname, config_props);
        config_props.putAll(arg_props);
        Agent.startAgent(config_props);
    }

    private static synchronized void startLocalManagementAgent() {
        Properties agentProps = VMSupport.getAgentProperties();
        if (agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP) == null) {
            JMXConnectorServer cs = ConnectorBootstrap.startLocalConnectorServer();
            String address = cs.getAddress().toString();
            agentProps.put(LOCAL_CONNECTOR_ADDRESS_PROP, address);
            try {
                ConnectorAddressLink.export(address);
            }
            catch (Exception x) {
                Agent.warning("agent.err.exportaddress.failed", x.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startRemoteManagementAgent(String args) throws Exception {
        String jmxremotePort;
        Properties sysProps;
        if (jmxServer != null) {
            throw new RuntimeException(Agent.getText("agent.err.invalid.state", "Agent already started"));
        }
        Properties argProps = Agent.parseString(args);
        Properties configProps = new Properties();
        String fname = System.getProperty(CONFIG_FILE);
        Agent.readConfiguration(fname, configProps);
        Properties properties = sysProps = System.getProperties();
        synchronized (properties) {
            configProps.putAll(sysProps);
        }
        String fnameUser = argProps.getProperty(CONFIG_FILE);
        if (fnameUser != null) {
            Agent.readConfiguration(fnameUser, configProps);
        }
        configProps.putAll(argProps);
        String enableThreadContentionMonitoring = configProps.getProperty(ENABLE_THREAD_CONTENTION_MONITORING);
        if (enableThreadContentionMonitoring != null) {
            ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(true);
        }
        if ((jmxremotePort = configProps.getProperty(JMXREMOTE_PORT)) != null) {
            jmxServer = ConnectorBootstrap.startRemoteConnectorServer(jmxremotePort, configProps);
            Agent.startDiscoveryService(configProps);
        }
    }

    private static synchronized void stopRemoteManagementAgent() throws Exception {
        JdpController.stopDiscoveryService();
        if (jmxServer != null) {
            ConnectorBootstrap.unexportRegistry();
            jmxServer.stop();
            jmxServer = null;
        }
    }

    private static void startAgent(Properties props) throws Exception {
        String snmpPort = props.getProperty(SNMP_PORT);
        String jmxremote = props.getProperty(JMXREMOTE);
        String jmxremotePort = props.getProperty(JMXREMOTE_PORT);
        String enableThreadContentionMonitoring = props.getProperty(ENABLE_THREAD_CONTENTION_MONITORING);
        if (enableThreadContentionMonitoring != null) {
            ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(true);
        }
        try {
            if (snmpPort != null) {
                Agent.loadSnmpAgent(snmpPort, props);
            }
            if (jmxremote != null || jmxremotePort != null) {
                if (jmxremotePort != null) {
                    jmxServer = ConnectorBootstrap.startRemoteConnectorServer(jmxremotePort, props);
                    Agent.startDiscoveryService(props);
                }
                Agent.startLocalManagementAgent();
            }
        }
        catch (AgentConfigurationError e) {
            Agent.error(e.getError(), e.getParams());
        }
        catch (Exception e) {
            Agent.error(e);
        }
    }

    private static void startDiscoveryService(Properties props) throws IOException {
        String discoveryPort = props.getProperty("com.sun.management.jdp.port");
        String discoveryAddress = props.getProperty("com.sun.management.jdp.address");
        String discoveryShouldStart = props.getProperty("com.sun.management.jmxremote.autodiscovery");
        boolean shouldStart = false;
        if (discoveryShouldStart == null) {
            shouldStart = discoveryPort != null;
        } else {
            try {
                shouldStart = Boolean.parseBoolean(discoveryShouldStart);
            }
            catch (NumberFormatException e) {
                throw new AgentConfigurationError("Couldn't parse autodiscovery argument");
            }
        }
        if (shouldStart) {
            InetAddress address;
            try {
                address = discoveryAddress == null ? InetAddress.getByName(JDP_DEFAULT_ADDRESS) : InetAddress.getByName(discoveryAddress);
            }
            catch (UnknownHostException e) {
                throw new AgentConfigurationError("Unable to broadcast to requested address", e);
            }
            int port = 7095;
            if (discoveryPort != null) {
                try {
                    port = Integer.parseInt(discoveryPort);
                }
                catch (NumberFormatException e) {
                    throw new AgentConfigurationError("Couldn't parse JDP port argument");
                }
            }
            String jmxremotePort = props.getProperty(JMXREMOTE_PORT);
            String rmiPort = props.getProperty(RMI_PORT);
            JMXServiceURL url = jmxServer.getAddress();
            String hostname = url.getHost();
            String jmxUrlStr = rmiPort != null ? String.format("service:jmx:rmi://%s:%s/jndi/rmi://%s:%s/jmxrmi", hostname, rmiPort, hostname, jmxremotePort) : String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", hostname, jmxremotePort);
            String instanceName = System.getProperty("com.sun.management.jdp.name");
            try {
                JdpController.startDiscoveryService(address, port, instanceName, jmxUrlStr);
            }
            catch (JdpException e) {
                throw new AgentConfigurationError("Couldn't start JDP service", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadManagementProperties() {
        Properties sysProps;
        Properties props = new Properties();
        String fname = System.getProperty(CONFIG_FILE);
        Agent.readConfiguration(fname, props);
        Properties properties = sysProps = System.getProperties();
        synchronized (properties) {
            props.putAll(sysProps);
        }
        return props;
    }

    public static synchronized Properties getManagementProperties() {
        if (mgmtProps == null) {
            String configFile = System.getProperty(CONFIG_FILE);
            String snmpPort = System.getProperty(SNMP_PORT);
            String jmxremote = System.getProperty(JMXREMOTE);
            String jmxremotePort = System.getProperty(JMXREMOTE_PORT);
            if (configFile == null && snmpPort == null && jmxremote == null && jmxremotePort == null) {
                return null;
            }
            mgmtProps = Agent.loadManagementProperties();
        }
        return mgmtProps;
    }

    private static void loadSnmpAgent(String snmpPort, Properties props) {
        try {
            Class<?> adaptorClass = Class.forName(SNMP_ADAPTOR_BOOTSTRAP_CLASS_NAME, true, null);
            Method initializeMethod = adaptorClass.getMethod("initialize", String.class, Properties.class);
            initializeMethod.invoke(null, snmpPort, props);
        }
        catch (ClassNotFoundException x) {
            throw new UnsupportedOperationException("Unsupported management property: com.sun.management.snmp.port", x);
        }
        catch (NoSuchMethodException x) {
            throw new UnsupportedOperationException("Unsupported management property: com.sun.management.snmp.port", x);
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UnsupportedOperationException("Unsupported management property: com.sun.management.snmp.port", cause);
        }
        catch (IllegalAccessException x) {
            throw new UnsupportedOperationException("Unsupported management property: com.sun.management.snmp.port", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfiguration(String fname, Properties p) {
        File configFile;
        if (fname == null) {
            String home = System.getProperty("java.home");
            if (home == null) {
                throw new Error("Can't find java.home ??");
            }
            StringBuffer defaultFileName = new StringBuffer(home);
            defaultFileName.append(File.separator).append("lib");
            defaultFileName.append(File.separator).append("management");
            defaultFileName.append(File.separator).append("management.properties");
            fname = defaultFileName.toString();
        }
        if (!(configFile = new File(fname)).exists()) {
            Agent.error("agent.err.configfile.notfound", fname);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            BufferedInputStream bin = new BufferedInputStream(in);
            p.load(bin);
        }
        catch (FileNotFoundException e) {
            Agent.error("agent.err.configfile.failed", e.getMessage());
        }
        catch (IOException e) {
            Agent.error("agent.err.configfile.failed", e.getMessage());
        }
        catch (SecurityException e) {
            Agent.error("agent.err.configfile.access.denied", fname);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    Agent.error("agent.err.configfile.closed.failed", fname);
                }
            }
        }
    }

    public static void startAgent() throws Exception {
        String args;
        String prop = System.getProperty("com.sun.management.agent.class");
        if (prop == null) {
            Properties props = Agent.getManagementProperties();
            if (props != null) {
                Agent.startAgent(props);
            }
            return;
        }
        String[] values = prop.split(":");
        if (values.length < 1 || values.length > 2) {
            Agent.error("agent.err.invalid.agentclass", "\"" + prop + "\"");
        }
        String cname = values[0];
        String string = args = values.length == 2 ? values[1] : null;
        if (cname == null || cname.length() == 0) {
            Agent.error("agent.err.invalid.agentclass", "\"" + prop + "\"");
        }
        if (cname != null) {
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(cname);
                Method premain = clz.getMethod("premain", String.class);
                premain.invoke(null, args);
            }
            catch (ClassNotFoundException ex) {
                Agent.error("agent.err.agentclass.notfound", "\"" + cname + "\"");
            }
            catch (NoSuchMethodException ex) {
                Agent.error("agent.err.premain.notfound", "\"" + cname + "\"");
            }
            catch (SecurityException ex) {
                Agent.error("agent.err.agentclass.access.denied");
            }
            catch (Exception ex) {
                String msg = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
                Agent.error("agent.err.agentclass.failed", msg);
            }
        }
    }

    public static void error(String key) {
        String keyText = Agent.getText(key);
        System.err.print(Agent.getText("agent.err.error") + ": " + keyText);
        throw new RuntimeException(keyText);
    }

    public static void error(String key, String[] params) {
        if (params == null || params.length == 0) {
            Agent.error(key);
        } else {
            StringBuffer message = new StringBuffer(params[0]);
            for (int i = 1; i < params.length; ++i) {
                message.append(" " + params[i]);
            }
            Agent.error(key, message.toString());
        }
    }

    public static void error(String key, String message) {
        String keyText = Agent.getText(key);
        System.err.print(Agent.getText("agent.err.error") + ": " + keyText);
        System.err.println(": " + message);
        throw new RuntimeException(keyText);
    }

    public static void error(Exception e) {
        e.printStackTrace();
        System.err.println(Agent.getText("agent.err.exception") + ": " + e.toString());
        throw new RuntimeException(e);
    }

    public static void warning(String key, String message) {
        System.err.print(Agent.getText("agent.err.warning") + ": " + Agent.getText(key));
        System.err.println(": " + message);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.management.resources.agent");
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for management agent is missing");
        }
    }

    public static String getText(String key) {
        if (messageRB == null) {
            Agent.initResource();
        }
        try {
            return messageRB.getString(key);
        }
        catch (MissingResourceException e) {
            return "Missing management agent resource bundle: key = \"" + key + "\"";
        }
    }

    public static String getText(String key, String ... args) {
        String format;
        if (messageRB == null) {
            Agent.initResource();
        }
        if ((format = messageRB.getString(key)) == null) {
            format = "missing resource key: key = \"" + key + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        return MessageFormat.format(format, args);
    }

    static {
        jmxServer = null;
    }
}

