/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.mbeanserver.WeakIdentityHashMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;

public class MXBeanLookup {
    private static final ThreadLocal<MXBeanLookup> currentLookup = new ThreadLocal();
    private final MBeanServerConnection mbsc;
    private final WeakIdentityHashMap<Object, ObjectName> mxbeanToObjectName = WeakIdentityHashMap.make();
    private final Map<ObjectName, WeakReference<Object>> objectNameToProxy = Util.newMap();
    private static final WeakIdentityHashMap<MBeanServerConnection, WeakReference<MXBeanLookup>> mbscToLookup = WeakIdentityHashMap.make();

    private MXBeanLookup(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MXBeanLookup lookupFor(MBeanServerConnection mbsc) {
        WeakIdentityHashMap<MBeanServerConnection, WeakReference<MXBeanLookup>> weakIdentityHashMap = mbscToLookup;
        synchronized (weakIdentityHashMap) {
            MXBeanLookup lookup;
            WeakReference<MXBeanLookup> weakLookup = mbscToLookup.get(mbsc);
            MXBeanLookup mXBeanLookup = lookup = weakLookup == null ? null : (MXBeanLookup)weakLookup.get();
            if (lookup == null) {
                lookup = new MXBeanLookup(mbsc);
                mbscToLookup.put(mbsc, new WeakReference<MXBeanLookup>(lookup));
            }
            return lookup;
        }
    }

    synchronized <T> T objectNameToMXBean(ObjectName name, Class<T> type) {
        Object proxy;
        WeakReference<Object> wr = this.objectNameToProxy.get(name);
        if (wr != null && type.isInstance(proxy = wr.get())) {
            return type.cast(proxy);
        }
        proxy = JMX.newMXBeanProxy(this.mbsc, name, type);
        this.objectNameToProxy.put(name, new WeakReference(proxy));
        return proxy;
    }

    synchronized ObjectName mxbeanToObjectName(Object mxbean) throws OpenDataException {
        String wrong;
        if (mxbean instanceof Proxy) {
            InvocationHandler ih = Proxy.getInvocationHandler(mxbean);
            if (ih instanceof MBeanServerInvocationHandler) {
                MBeanServerInvocationHandler mbsih = (MBeanServerInvocationHandler)ih;
                if (mbsih.getMBeanServerConnection().equals(this.mbsc)) {
                    return mbsih.getObjectName();
                }
                wrong = "proxy for a different MBeanServer";
            } else {
                wrong = "not a JMX proxy";
            }
        } else {
            ObjectName name = this.mxbeanToObjectName.get(mxbean);
            if (name != null) {
                return name;
            }
            wrong = "not an MXBean registered in this MBeanServer";
        }
        String s = mxbean == null ? "null" : "object of type " + mxbean.getClass().getName();
        throw new OpenDataException("Could not convert " + s + " to an ObjectName: " + wrong);
    }

    synchronized void addReference(ObjectName name, Object mxbean) throws InstanceAlreadyExistsException {
        String multiname;
        ObjectName existing = this.mxbeanToObjectName.get(mxbean);
        if (existing != null && !"true".equalsIgnoreCase(multiname = AccessController.doPrivileged(new GetPropertyAction("jmx.mxbean.multiname")))) {
            throw new InstanceAlreadyExistsException("MXBean already registered with name " + existing);
        }
        this.mxbeanToObjectName.put(mxbean, name);
    }

    synchronized boolean removeReference(ObjectName name, Object mxbean) {
        if (name.equals(this.mxbeanToObjectName.get(mxbean))) {
            this.mxbeanToObjectName.remove(mxbean);
            return true;
        }
        return false;
    }

    static MXBeanLookup getLookup() {
        return currentLookup.get();
    }

    static void setLookup(MXBeanLookup lookup) {
        currentLookup.set(lookup);
    }
}

