/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import sun.management.NotificationEmitterSupport;
import sun.management.Util;

class MemoryManagerImpl
extends NotificationEmitterSupport
implements MemoryManagerMXBean {
    private final String name;
    private final boolean isValid;
    private MemoryPoolMXBean[] pools;
    private MBeanNotificationInfo[] notifInfo = null;

    MemoryManagerImpl(String name) {
        this.name = name;
        this.isValid = true;
        this.pools = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String[] getMemoryPoolNames() {
        MemoryPoolMXBean[] ps = this.getMemoryPools();
        String[] names = new String[ps.length];
        for (int i = 0; i < ps.length; ++i) {
            names[i] = ps[i].getName();
        }
        return names;
    }

    synchronized MemoryPoolMXBean[] getMemoryPools() {
        if (this.pools == null) {
            this.pools = this.getMemoryPools0();
        }
        return this.pools;
    }

    private native MemoryPoolMXBean[] getMemoryPools0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MemoryManagerImpl memoryManagerImpl = this;
        synchronized (memoryManagerImpl) {
            if (this.notifInfo == null) {
                this.notifInfo = new MBeanNotificationInfo[0];
            }
        }
        return this.notifInfo;
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=MemoryManager", this.getName());
    }
}

