/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.test.TestUtils;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateSignatureTest
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$signature$CreateSignatureTest == null ? (class$org$apache$xml$security$test$signature$CreateSignatureTest = CreateSignatureTest.class$("org.apache.xml.security.test.signature.CreateSignatureTest")) : class$org$apache$xml$security$test$signature$CreateSignatureTest).getName());
    private static final String BASEDIR = System.getProperty("basedir");
    private static final String SEP = System.getProperty("file.separator");
    KeyPair kp = null;
    DocumentBuilder db;
    static /* synthetic */ Class class$org$apache$xml$security$test$signature$CreateSignatureTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$test$signature$CreateSignatureTest == null ? (class$org$apache$xml$security$test$signature$CreateSignatureTest = CreateSignatureTest.class$("org.apache.xml.security.test.signature.CreateSignatureTest")) : class$org$apache$xml$security$test$signature$CreateSignatureTest);
    }

    public CreateSignatureTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-noloading", (class$org$apache$xml$security$test$signature$CreateSignatureTest == null ? (class$org$apache$xml$security$test$signature$CreateSignatureTest = CreateSignatureTest.class$("org.apache.xml.security.test.signature.CreateSignatureTest")) : class$org$apache$xml$security$test$signature$CreateSignatureTest).getName()};
        TestRunner.main((String[])stringArray2);
    }

    public void testEmptyNodeSet() throws Exception {
        Document document = this.db.newDocument();
        Element element = document.createElementNS("http://www.usps.gov/", "Envelope");
        element.appendChild(document.createTextNode("\n"));
        document.appendChild(element);
        XMLSignature xMLSignature = new XMLSignature(document, null, "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        ObjectContainer objectContainer = new ObjectContainer(document);
        objectContainer.setId("object-1");
        objectContainer.setMimeType("text/plain");
        xMLSignature.appendObject(objectContainer);
        ObjectContainer objectContainer2 = new ObjectContainer(document);
        objectContainer2.setId("object-2");
        objectContainer2.setMimeType("text/plain");
        objectContainer2.setEncoding("http://www.w3.org/2000/09/xmldsig#base64");
        objectContainer2.appendChild((Node)document.createTextNode("SSBhbSB0aGUgdGV4dC4="));
        xMLSignature.appendObject(objectContainer2);
        Transforms transforms = new Transforms(document);
        XPathContainer xPathContainer = new XPathContainer(document);
        xPathContainer.setXPath("self::text()");
        transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xPathContainer.getElementPlusReturns());
        xMLSignature.addDocument("#object-1", transforms, "http://www.w3.org/2000/09/xmldsig#sha1", null, "http://www.w3.org/2000/09/xmldsig#Object");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + "data/org/apache/xml/security/samples/input/keystore.jks") : new FileInputStream("data/org/apache/xml/security/samples/input/keystore.jks");
        keyStore.load(fileInputStream, "xmlsecurity".toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey("test", "xmlsecurity".toCharArray());
        xMLSignature.sign((Key)privateKey);
    }

    protected void setUp() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.db = documentBuilderFactory.newDocumentBuilder();
        Init.init();
        this.kp = KeyPairGenerator.getInstance("RSA").genKeyPair();
    }

    public void testOne() throws Exception {
        this.doVerify(this.doSign());
        this.doVerify(this.doSign());
    }

    public void testTwo() throws Exception {
        this.doSignWithCert();
    }

    public void testWithNSPrefixDisabled() throws Exception {
        String string = Constants.getSignatureSpecNSprefix();
        try {
            Constants.setSignatureSpecNSprefix((String)"");
            this.doSign();
            Constants.setSignatureSpecNSprefix((String)string);
        }
        catch (Exception exception) {
            Constants.setSignatureSpecNSprefix((String)string);
            throw exception;
        }
    }

    String doSign() throws Exception {
        PrivateKey privateKey = this.kp.getPrivate();
        Document document = this.db.newDocument();
        document.appendChild(document.createComment(" Comment before "));
        Element element = document.createElementNS("", "RootElement");
        document.appendChild(element);
        element.appendChild(document.createTextNode("Some simple text\n"));
        Element element2 = XMLUtils.createElementInSignatureSpace((Document)document, (String)"CanonicalizationMethod");
        element2.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(document, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        XMLSignature xMLSignature = new XMLSignature(document, null, signatureAlgorithm.getElement(), element2);
        element.appendChild(xMLSignature.getElement());
        document.appendChild(document.createComment(" Comment after "));
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xMLSignature.addKeyInfo(this.kp.getPublic());
        xMLSignature.sign((Key)privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    String doSignWithCert() throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = null;
        fileInputStream = BASEDIR != null && !"".equals(BASEDIR) ? new FileInputStream(BASEDIR + SEP + "data/test.jks") : new FileInputStream("data/test.jks");
        keyStore.load(fileInputStream, "changeit".toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey("mullan", "changeit".toCharArray());
        Document document = this.db.newDocument();
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate("mullan");
        document.appendChild(document.createComment(" Comment before "));
        Element element = document.createElementNS("", "RootElement");
        document.appendChild(element);
        element.appendChild(document.createTextNode("Some simple text\n"));
        Element element2 = XMLUtils.createElementInSignatureSpace((Document)document, (String)"CanonicalizationMethod");
        element2.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(document, "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        XMLSignature xMLSignature = new XMLSignature(document, null, signatureAlgorithm.getElement(), element2);
        element.appendChild(xMLSignature.getElement());
        document.appendChild(document.createComment(" Comment after "));
        Transforms transforms = new Transforms(document);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xMLSignature.addKeyInfo(x509Certificate);
        xMLSignature.sign((Key)privateKey);
        X509Certificate x509Certificate2 = xMLSignature.getKeyInfo().getX509Certificate();
        xMLSignature.checkSignatureValue((Key)x509Certificate2.getPublicKey());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)document, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    void doVerify(String string) throws Exception {
        Element element;
        Document document = this.db.parse(new ByteArrayInputStream(string.getBytes()));
        Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)(element = TestUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#")));
        XMLSignature xMLSignature = new XMLSignature(element2, "");
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        if (keyInfo == null) {
            throw new RuntimeException("No keyinfo");
        }
        PublicKey publicKey = xMLSignature.getKeyInfo().getPublicKey();
        if (publicKey == null) {
            throw new RuntimeException("No public key");
        }
        CreateSignatureTest.assertTrue((boolean)xMLSignature.checkSignatureValue((Key)publicKey));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

