/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class PurchaseReservedInstancesOffering
extends BaseCmd {
    private static final String PURCHASE_INSTANCE_COUNT_ARG = "INSTANCE-COUNT";
    private static final String PURCHASE_INSTANCE_COUNT = "instance-count";
    private static final String PURCHASE_OFFERING_ARG = "OFFERING";
    private static final String PURCHASE_OFFERING = "offering";
    private static final String LIMIT_PRICE = "limit-price";
    private static final String LIMIT_PRICE_ARG = "LIMIT-PRICE";
    private static final String CURRENCY_CODE = "currency-code";
    private static final String CURRENCY_CODE_ARG = "CURRENCY-CODE";
    private static final String[] CURRENCY_CODE_DESC = new String[]{"Specify the 3 character CURRENCY-CODE that the LIMIT-PRICE is specified in.", "Can only be specified with LIMIT-PRICE.", "Defaults to USD if not specified."};

    public PurchaseReservedInstancesOffering(String[] args) {
        super("ec2prio", "ec2-purchase-reserved-instances-offering");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)PURCHASE_OFFERING);
        OptionBuilder.withDescription((String)this.joinDescription("Purchase reserved instance from the reserved instances offering specified OFFERING."));
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)PURCHASE_OFFERING_ARG);
        result.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)PURCHASE_INSTANCE_COUNT);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)this.joinDescription("Purchase the number of instances specified by INSTANCE-COUNT from the reserved instances offering."));
        OptionBuilder.withArgName((String)PURCHASE_INSTANCE_COUNT_ARG);
        result.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)LIMIT_PRICE);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)this.joinDescription("Set the maximum price that you are willing to pay, specified by LIMIT-PRICE."));
        OptionBuilder.withArgName((String)LIMIT_PRICE_ARG);
        result.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)CURRENCY_CODE);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)this.joinDescription("Specify the 3 character CURRENCY-CODE that the LIMIT-PRICE is specified in. Can only be specified with a LIMIT-PRICE. Defaults to USD."));
        OptionBuilder.withArgName((String)CURRENCY_CODE_ARG);
        result.addOption(OptionBuilder.create(null));
        return result;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Purchase reserved instances from a reserved instances offering.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        super.printOption(PURCHASE_OFFERING);
        super.printOption(PURCHASE_INSTANCE_COUNT);
        super.printOption(LIMIT_PRICE);
        super.printOption(CURRENCY_CODE);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        int instanceCount;
        this.assertOptionSet(PURCHASE_OFFERING);
        this.assertOptionSet(PURCHASE_INSTANCE_COUNT);
        if (this.isOptionSet(CURRENCY_CODE)) {
            this.assertOptionSet(LIMIT_PRICE);
        }
        Double limitPrice = null;
        try {
            instanceCount = Integer.parseInt(this.getOptionValue(PURCHASE_INSTANCE_COUNT));
        }
        catch (NumberFormatException e) {
            throw new InvalidArgument(PURCHASE_INSTANCE_COUNT, this.getOptionValue(PURCHASE_INSTANCE_COUNT));
        }
        if (this.isOptionSet(LIMIT_PRICE)) {
            try {
                limitPrice = Double.parseDouble(this.getOptionValue(LIMIT_PRICE));
            }
            catch (NumberFormatException e) {
                throw new InvalidArgument(LIMIT_PRICE, this.getOptionValue(LIMIT_PRICE));
            }
        }
        RequestResultPair rsp = jec2.purchaseReservedInstancesOffering(this.getOptionValue(PURCHASE_OFFERING), instanceCount, limitPrice, this.getOptionValue(CURRENCY_CODE));
        out.outputReservedInstancesId(System.out, (String)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    @Override
    protected String getOptionString() {
        return String.format("-c %s -o %s [-l %s]", PURCHASE_INSTANCE_COUNT_ARG, PURCHASE_OFFERING_ARG, LIMIT_PRICE_ARG);
    }

    public static void main(String[] args) {
        new PurchaseReservedInstancesOffering(args).invoke();
    }
}

