/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.ResourceTagDescription;
import com.amazon.aes.webservices.client.UserIdGroupPair;
import java.util.ArrayList;
import java.util.List;

public class SecurityGroupDescription {
    public String name;
    public String desc;
    public String owner;
    public String id;
    public String vpcId;
    public List<IpPermission> perms = new ArrayList<IpPermission>();
    public List<ResourceTagDescription> tags;

    public SecurityGroupDescription(String name, String desc, String owner) {
        this.name = name;
        this.desc = desc;
        this.owner = owner;
    }

    public SecurityGroupDescription(String name, String desc, String owner, String id) {
        this(name, desc, owner);
        this.id = id;
    }

    public SecurityGroupDescription(String name, String desc, String owner, String id, String vpcId) {
        this(name, desc, owner, id);
        this.vpcId = vpcId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IpPermission addPermission(String protocol, Integer fromPort, Integer toPort) {
        IpPermission perm = new IpPermission(protocol, fromPort, toPort);
        this.perms.add(perm);
        return perm;
    }

    public IpPermission addPermission(String protocol, Integer fromPort, Integer toPort, Boolean egress) {
        IpPermission perm = new IpPermission(protocol, fromPort, toPort);
        perm.egress = egress;
        this.perms.add(perm);
        return perm;
    }

    public String toString() {
        return "SecurityGroup[name=" + this.name + ", Desc=" + this.desc + ", own=" + this.owner + ", perms=" + this.perms + "]";
    }

    public class IpPermission {
        public String protocol;
        public Integer fromPort;
        public Integer toPort;
        public Boolean egress = false;
        public List<String> cidrIps = new ArrayList<String>();
        public List<UserIdGroupPair> uid_group_pairs = new ArrayList<UserIdGroupPair>();

        public IpPermission(String protocol, Integer fromPort, Integer toPort) {
            this.protocol = protocol;
            this.fromPort = fromPort;
            this.toPort = toPort;
        }

        public void addIpRange(String cidrIp) {
            this.cidrIps.add(cidrIp);
        }

        public void addUserGroupPair(String userId, String groupId, String groupName) {
            UserIdGroupPair pair = new UserIdGroupPair();
            pair.setUserId(userId);
            pair.setGroupId(groupId);
            pair.setName(groupName);
            this.uid_group_pairs.add(pair);
        }

        public String toString() {
            ArrayList<String> uid_grp_str = new ArrayList<String>();
            for (UserIdGroupPair pair : this.uid_group_pairs) {
                uid_grp_str.add("(" + pair.getUserId() + "," + pair.getGroupId() + pair.getName() + ")");
            }
            return "[proto=" + this.protocol + ", portRng=(" + this.fromPort + ".." + this.toPort + "), cidrIps=" + this.cidrIps + ", uidgrp=" + uid_grp_str + "]";
        }
    }
}

