/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Ticket
implements Cloneable {
    public int tkt_vno;
    public PrincipalName sname;
    public EncryptedData encPart;

    private Ticket() {
    }

    public Object clone() {
        Ticket new_ticket = new Ticket();
        new_ticket.sname = (PrincipalName)this.sname.clone();
        new_ticket.encPart = (EncryptedData)this.encPart.clone();
        new_ticket.tkt_vno = this.tkt_vno;
        return new_ticket;
    }

    public Ticket(PrincipalName new_sname, EncryptedData new_encPart) {
        this.tkt_vno = 5;
        this.sname = new_sname;
        this.encPart = new_encPart;
    }

    public Ticket(byte[] data) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(new DerValue(data));
    }

    public Ticket(DerValue encoding) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((encoding.getTag() & 0x1F) != 1 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.tkt_vno = subDer.getData().getBigInteger().intValue();
        if (this.tkt_vno != 5) {
            throw new KrbApErrException(39);
        }
        Realm srealm = Realm.parse(der.getData(), (byte)1, false);
        this.sname = PrincipalName.parse(der.getData(), (byte)2, false, srealm);
        this.encPart = EncryptedData.parse(der.getData(), (byte)3, false);
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        DerValue[] der = new DerValue[4];
        temp.putInteger(BigInteger.valueOf(this.tkt_vno));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), this.sname.getRealm().asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)2), this.sname.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)3), this.encPart.asn1Encode());
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        DerOutputStream ticket = new DerOutputStream();
        ticket.write(DerValue.createTag((byte)64, true, (byte)1), temp);
        return ticket.toByteArray();
    }

    public static Ticket parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException, RealmException, KrbApErrException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new Ticket(subDer);
    }
}

