/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.NotContextException;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;

public class InitialLdapContext
extends InitialDirContext
implements LdapContext {
    private static final String BIND_CONTROLS_PROPERTY = "java.naming.ldap.control.connect";

    public InitialLdapContext() throws NamingException {
        super(null);
    }

    public InitialLdapContext(Hashtable<?, ?> environment, Control[] connCtls) throws NamingException {
        super(true);
        Hashtable<String, Object> env;
        Hashtable<String, Object> hashtable = env = environment == null ? new Hashtable<String, Object>(11) : (Hashtable)environment.clone();
        if (connCtls != null) {
            Control[] copy = new Control[connCtls.length];
            System.arraycopy(connCtls, 0, copy, 0, connCtls.length);
            env.put(BIND_CONTROLS_PROPERTY, copy);
        }
        env.put("java.naming.ldap.version", "3");
        this.init(env);
    }

    private LdapContext getDefaultLdapInitCtx() throws NamingException {
        Context answer = this.getDefaultInitCtx();
        if (!(answer instanceof LdapContext)) {
            if (answer == null) {
                throw new NoInitialContextException();
            }
            throw new NotContextException("Not an instance of LdapContext");
        }
        return (LdapContext)answer;
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) throws NamingException {
        return this.getDefaultLdapInitCtx().extendedOperation(request);
    }

    @Override
    public LdapContext newInstance(Control[] reqCtls) throws NamingException {
        return this.getDefaultLdapInitCtx().newInstance(reqCtls);
    }

    @Override
    public void reconnect(Control[] connCtls) throws NamingException {
        this.getDefaultLdapInitCtx().reconnect(connCtls);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return this.getDefaultLdapInitCtx().getConnectControls();
    }

    @Override
    public void setRequestControls(Control[] requestControls) throws NamingException {
        this.getDefaultLdapInitCtx().setRequestControls(requestControls);
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return this.getDefaultLdapInitCtx().getRequestControls();
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.getDefaultLdapInitCtx().getResponseControls();
    }
}

