/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.Color;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;

public class GTKColorType
extends ColorType {
    public static final ColorType LIGHT = new GTKColorType("Light");
    public static final ColorType DARK = new GTKColorType("Dark");
    public static final ColorType MID = new GTKColorType("Mid");
    public static final ColorType BLACK = new GTKColorType("Black");
    public static final ColorType WHITE = new GTKColorType("White");
    public static final int MAX_COUNT;
    private static final float[] HLS_COLORS;
    private static final Object HLS_COLOR_LOCK;

    private static int hlsToRGB(float h, float l, float s) {
        float r;
        float g;
        float b;
        float m2 = l <= 0.5f ? l * (1.0f + s) : l + s - l * s;
        float m1 = 2.0f * l - m2;
        if ((double)s == 0.0) {
            if ((double)h == 0.0) {
                g = b = l;
                r = b;
            } else {
                b = 0.0f;
                g = 0.0f;
                r = 0.0f;
            }
        } else {
            r = GTKColorType.hlsValue(m1, m2, h + 120.0f);
            g = GTKColorType.hlsValue(m1, m2, h);
            b = GTKColorType.hlsValue(m1, m2, h - 120.0f);
        }
        return (int)(r * 255.0f) << 16 | (int)((double)g * 255.0) << 8 | (int)(b * 255.0f);
    }

    private static float hlsValue(float n1, float n2, float h) {
        if (h > 360.0f) {
            h -= 360.0f;
        } else if (h < 0.0f) {
            h += 360.0f;
        }
        if (h < 60.0f) {
            return n1 + (n2 - n1) * h / 60.0f;
        }
        if (h < 180.0f) {
            return n2;
        }
        if (h < 240.0f) {
            return n1 + (n2 - n1) * (240.0f - h) / 60.0f;
        }
        return n1;
    }

    private static float[] rgbToHLS(int rgb, float[] hls) {
        float r = (float)((rgb & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((rgb & 0xFF00) >> 8) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        float max = Math.max(Math.max(r, g), b);
        float min = Math.min(Math.min(r, g), b);
        float l = (max + min) / 2.0f;
        float s = 0.0f;
        float h = 0.0f;
        if (max != min) {
            float delta = max - min;
            float f = s = l <= 0.5f ? delta / (max + min) : delta / (2.0f - max - min);
            h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
            if ((h *= 60.0f) < 0.0f) {
                h += 360.0f;
            }
        }
        if (hls == null) {
            hls = new float[]{h, l, s};
        }
        return hls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Color adjustColor(Color color, float hFactor, float lFactor, float sFactor) {
        float s;
        float l;
        float h;
        Object object = HLS_COLOR_LOCK;
        synchronized (object) {
            float[] hls = GTKColorType.rgbToHLS(color.getRGB(), HLS_COLORS);
            h = hls[0];
            l = hls[1];
            s = hls[2];
        }
        h = Math.min(360.0f, hFactor * h);
        l = Math.min(1.0f, lFactor * l);
        s = Math.min(1.0f, sFactor * s);
        return new ColorUIResource(GTKColorType.hlsToRGB(h, l, s));
    }

    protected GTKColorType(String name) {
        super(name);
    }

    static {
        HLS_COLORS = new float[3];
        HLS_COLOR_LOCK = new Object();
        MAX_COUNT = WHITE.getID() + 1;
    }
}

