/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import javax.naming.CompositeName;
import javax.naming.Name;

public class NamingException
extends Exception {
    protected Name resolvedName = null;
    protected Object resolvedObj = null;
    protected Name remainingName = null;
    protected Throwable rootException = null;
    private static final long serialVersionUID = -1299181962103167177L;

    public NamingException(String explanation) {
        super(explanation);
    }

    public NamingException() {
    }

    public Name getResolvedName() {
        return this.resolvedName;
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public String getExplanation() {
        return this.getMessage();
    }

    public void setResolvedName(Name name) {
        this.resolvedName = name != null ? (Name)name.clone() : null;
    }

    public void setRemainingName(Name name) {
        this.remainingName = name != null ? (Name)name.clone() : null;
    }

    public void setResolvedObj(Object obj) {
        this.resolvedObj = obj;
    }

    public void appendRemainingComponent(String name) {
        if (name != null) {
            try {
                if (this.remainingName == null) {
                    this.remainingName = new CompositeName();
                }
                this.remainingName.add(name);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    public void appendRemainingName(Name name) {
        if (name == null) {
            return;
        }
        if (this.remainingName != null) {
            try {
                this.remainingName.addAll(name);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException(e.toString());
            }
        } else {
            this.remainingName = (Name)name.clone();
        }
    }

    public Throwable getRootCause() {
        return this.rootException;
    }

    public void setRootCause(Throwable e) {
        if (e != this) {
            this.rootException = e;
        }
    }

    @Override
    public Throwable getCause() {
        return this.getRootCause();
    }

    @Override
    public Throwable initCause(Throwable cause) {
        super.initCause(cause);
        this.setRootCause(cause);
        return this;
    }

    @Override
    public String toString() {
        String answer = super.toString();
        if (this.rootException != null) {
            answer = answer + " [Root exception is " + this.rootException + "]";
        }
        if (this.remainingName != null) {
            answer = answer + "; remaining name '" + this.remainingName + "'";
        }
        return answer;
    }

    public String toString(boolean detail) {
        if (!detail || this.resolvedObj == null) {
            return this.toString();
        }
        return this.toString() + "; resolved object " + this.resolvedObj;
    }
}

