/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe.hw;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.java2d.pipe.hw.AccelDeviceEventListener;

public class AccelDeviceEventNotifier {
    private static AccelDeviceEventNotifier theInstance;
    public static final int DEVICE_RESET = 0;
    public static final int DEVICE_DISPOSED = 1;
    private final Map<AccelDeviceEventListener, Integer> listeners = Collections.synchronizedMap(new HashMap(1));

    private AccelDeviceEventNotifier() {
    }

    private static synchronized AccelDeviceEventNotifier getInstance(boolean create) {
        if (theInstance == null && create) {
            theInstance = new AccelDeviceEventNotifier();
        }
        return theInstance;
    }

    public static final void eventOccured(int screen, int eventType) {
        AccelDeviceEventNotifier notifier = AccelDeviceEventNotifier.getInstance(false);
        if (notifier != null) {
            notifier.notifyListeners(eventType, screen);
        }
    }

    public static final void addListener(AccelDeviceEventListener l, int screen) {
        AccelDeviceEventNotifier.getInstance(true).add(l, screen);
    }

    public static final void removeListener(AccelDeviceEventListener l) {
        AccelDeviceEventNotifier.getInstance(true).remove(l);
    }

    private final void add(AccelDeviceEventListener theListener, int screen) {
        this.listeners.put(theListener, screen);
    }

    private final void remove(AccelDeviceEventListener theListener) {
        this.listeners.remove(theListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyListeners(int deviceEventType, int screen) {
        HashMap<AccelDeviceEventListener, Integer> listClone;
        Map<AccelDeviceEventListener, Integer> map = this.listeners;
        synchronized (map) {
            listClone = new HashMap<AccelDeviceEventListener, Integer>(this.listeners);
        }
        Set<AccelDeviceEventListener> cloneSet = listClone.keySet();
        for (AccelDeviceEventListener current : cloneSet) {
            Integer i = listClone.get(current);
            if (i != null && i != screen) continue;
            if (deviceEventType == 0) {
                current.onDeviceReset();
                continue;
            }
            if (deviceEventType != 1) continue;
            current.onDeviceDispose();
        }
    }
}

