/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import sun.misc.JavaNioAccess;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.misc.VM;

class Bits {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final ByteOrder byteOrder = unsafe.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    private static int pageSize = -1;
    private static boolean unaligned = unsafe.unalignedAccess();
    private static volatile long maxMemory = VM.maxDirectMemory();
    private static volatile long reservedMemory;
    private static volatile long totalCapacity;
    private static volatile long count;
    private static boolean memoryLimitSet;
    static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    static final int JNI_COPY_FROM_ARRAY_THRESHOLD = 6;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private Bits() {
    }

    static short swap(short x) {
        return Short.reverseBytes(x);
    }

    static char swap(char x) {
        return Character.reverseBytes(x);
    }

    static int swap(int x) {
        return Integer.reverseBytes(x);
    }

    static long swap(long x) {
        return Long.reverseBytes(x);
    }

    private static char makeChar(byte b1, byte b0) {
        return (char)(b1 << 8 | b0 & 0xFF);
    }

    static char getCharL(ByteBuffer bb, int bi) {
        return Bits.makeChar(bb._get(bi + 1), bb._get(bi));
    }

    static char getCharL(long a) {
        return Bits.makeChar(Bits._get(a + 1L), Bits._get(a));
    }

    static char getCharB(ByteBuffer bb, int bi) {
        return Bits.makeChar(bb._get(bi), bb._get(bi + 1));
    }

    static char getCharB(long a) {
        return Bits.makeChar(Bits._get(a), Bits._get(a + 1L));
    }

    static char getChar(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getCharB(bb, bi) : Bits.getCharL(bb, bi);
    }

    static char getChar(long a, boolean bigEndian) {
        return bigEndian ? Bits.getCharB(a) : Bits.getCharL(a);
    }

    private static byte char1(char x) {
        return (byte)(x >> 8);
    }

    private static byte char0(char x) {
        return (byte)x;
    }

    static void putCharL(ByteBuffer bb, int bi, char x) {
        bb._put(bi, Bits.char0(x));
        bb._put(bi + 1, Bits.char1(x));
    }

    static void putCharL(long a, char x) {
        Bits._put(a, Bits.char0(x));
        Bits._put(a + 1L, Bits.char1(x));
    }

    static void putCharB(ByteBuffer bb, int bi, char x) {
        bb._put(bi, Bits.char1(x));
        bb._put(bi + 1, Bits.char0(x));
    }

    static void putCharB(long a, char x) {
        Bits._put(a, Bits.char1(x));
        Bits._put(a + 1L, Bits.char0(x));
    }

    static void putChar(ByteBuffer bb, int bi, char x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putCharB(bb, bi, x);
        } else {
            Bits.putCharL(bb, bi, x);
        }
    }

    static void putChar(long a, char x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putCharB(a, x);
        } else {
            Bits.putCharL(a, x);
        }
    }

    private static short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    static short getShortL(ByteBuffer bb, int bi) {
        return Bits.makeShort(bb._get(bi + 1), bb._get(bi));
    }

    static short getShortL(long a) {
        return Bits.makeShort(Bits._get(a + 1L), Bits._get(a));
    }

    static short getShortB(ByteBuffer bb, int bi) {
        return Bits.makeShort(bb._get(bi), bb._get(bi + 1));
    }

    static short getShortB(long a) {
        return Bits.makeShort(Bits._get(a), Bits._get(a + 1L));
    }

    static short getShort(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getShortB(bb, bi) : Bits.getShortL(bb, bi);
    }

    static short getShort(long a, boolean bigEndian) {
        return bigEndian ? Bits.getShortB(a) : Bits.getShortL(a);
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    static void putShortL(ByteBuffer bb, int bi, short x) {
        bb._put(bi, Bits.short0(x));
        bb._put(bi + 1, Bits.short1(x));
    }

    static void putShortL(long a, short x) {
        Bits._put(a, Bits.short0(x));
        Bits._put(a + 1L, Bits.short1(x));
    }

    static void putShortB(ByteBuffer bb, int bi, short x) {
        bb._put(bi, Bits.short1(x));
        bb._put(bi + 1, Bits.short0(x));
    }

    static void putShortB(long a, short x) {
        Bits._put(a, Bits.short1(x));
        Bits._put(a + 1L, Bits.short0(x));
    }

    static void putShort(ByteBuffer bb, int bi, short x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putShortB(bb, bi, x);
        } else {
            Bits.putShortL(bb, bi, x);
        }
    }

    static void putShort(long a, short x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putShortB(a, x);
        } else {
            Bits.putShortL(a, x);
        }
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    static int getIntL(ByteBuffer bb, int bi) {
        return Bits.makeInt(bb._get(bi + 3), bb._get(bi + 2), bb._get(bi + 1), bb._get(bi));
    }

    static int getIntL(long a) {
        return Bits.makeInt(Bits._get(a + 3L), Bits._get(a + 2L), Bits._get(a + 1L), Bits._get(a));
    }

    static int getIntB(ByteBuffer bb, int bi) {
        return Bits.makeInt(bb._get(bi), bb._get(bi + 1), bb._get(bi + 2), bb._get(bi + 3));
    }

    static int getIntB(long a) {
        return Bits.makeInt(Bits._get(a), Bits._get(a + 1L), Bits._get(a + 2L), Bits._get(a + 3L));
    }

    static int getInt(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getIntB(bb, bi) : Bits.getIntL(bb, bi);
    }

    static int getInt(long a, boolean bigEndian) {
        return bigEndian ? Bits.getIntB(a) : Bits.getIntL(a);
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    static void putIntL(ByteBuffer bb, int bi, int x) {
        bb._put(bi + 3, Bits.int3(x));
        bb._put(bi + 2, Bits.int2(x));
        bb._put(bi + 1, Bits.int1(x));
        bb._put(bi, Bits.int0(x));
    }

    static void putIntL(long a, int x) {
        Bits._put(a + 3L, Bits.int3(x));
        Bits._put(a + 2L, Bits.int2(x));
        Bits._put(a + 1L, Bits.int1(x));
        Bits._put(a, Bits.int0(x));
    }

    static void putIntB(ByteBuffer bb, int bi, int x) {
        bb._put(bi, Bits.int3(x));
        bb._put(bi + 1, Bits.int2(x));
        bb._put(bi + 2, Bits.int1(x));
        bb._put(bi + 3, Bits.int0(x));
    }

    static void putIntB(long a, int x) {
        Bits._put(a, Bits.int3(x));
        Bits._put(a + 1L, Bits.int2(x));
        Bits._put(a + 2L, Bits.int1(x));
        Bits._put(a + 3L, Bits.int0(x));
    }

    static void putInt(ByteBuffer bb, int bi, int x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putIntB(bb, bi, x);
        } else {
            Bits.putIntL(bb, bi, x);
        }
    }

    static void putInt(long a, int x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putIntB(a, x);
        } else {
            Bits.putIntL(a, x);
        }
    }

    private static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }

    static long getLongL(ByteBuffer bb, int bi) {
        return Bits.makeLong(bb._get(bi + 7), bb._get(bi + 6), bb._get(bi + 5), bb._get(bi + 4), bb._get(bi + 3), bb._get(bi + 2), bb._get(bi + 1), bb._get(bi));
    }

    static long getLongL(long a) {
        return Bits.makeLong(Bits._get(a + 7L), Bits._get(a + 6L), Bits._get(a + 5L), Bits._get(a + 4L), Bits._get(a + 3L), Bits._get(a + 2L), Bits._get(a + 1L), Bits._get(a));
    }

    static long getLongB(ByteBuffer bb, int bi) {
        return Bits.makeLong(bb._get(bi), bb._get(bi + 1), bb._get(bi + 2), bb._get(bi + 3), bb._get(bi + 4), bb._get(bi + 5), bb._get(bi + 6), bb._get(bi + 7));
    }

    static long getLongB(long a) {
        return Bits.makeLong(Bits._get(a), Bits._get(a + 1L), Bits._get(a + 2L), Bits._get(a + 3L), Bits._get(a + 4L), Bits._get(a + 5L), Bits._get(a + 6L), Bits._get(a + 7L));
    }

    static long getLong(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getLongB(bb, bi) : Bits.getLongL(bb, bi);
    }

    static long getLong(long a, boolean bigEndian) {
        return bigEndian ? Bits.getLongB(a) : Bits.getLongL(a);
    }

    private static byte long7(long x) {
        return (byte)(x >> 56);
    }

    private static byte long6(long x) {
        return (byte)(x >> 48);
    }

    private static byte long5(long x) {
        return (byte)(x >> 40);
    }

    private static byte long4(long x) {
        return (byte)(x >> 32);
    }

    private static byte long3(long x) {
        return (byte)(x >> 24);
    }

    private static byte long2(long x) {
        return (byte)(x >> 16);
    }

    private static byte long1(long x) {
        return (byte)(x >> 8);
    }

    private static byte long0(long x) {
        return (byte)x;
    }

    static void putLongL(ByteBuffer bb, int bi, long x) {
        bb._put(bi + 7, Bits.long7(x));
        bb._put(bi + 6, Bits.long6(x));
        bb._put(bi + 5, Bits.long5(x));
        bb._put(bi + 4, Bits.long4(x));
        bb._put(bi + 3, Bits.long3(x));
        bb._put(bi + 2, Bits.long2(x));
        bb._put(bi + 1, Bits.long1(x));
        bb._put(bi, Bits.long0(x));
    }

    static void putLongL(long a, long x) {
        Bits._put(a + 7L, Bits.long7(x));
        Bits._put(a + 6L, Bits.long6(x));
        Bits._put(a + 5L, Bits.long5(x));
        Bits._put(a + 4L, Bits.long4(x));
        Bits._put(a + 3L, Bits.long3(x));
        Bits._put(a + 2L, Bits.long2(x));
        Bits._put(a + 1L, Bits.long1(x));
        Bits._put(a, Bits.long0(x));
    }

    static void putLongB(ByteBuffer bb, int bi, long x) {
        bb._put(bi, Bits.long7(x));
        bb._put(bi + 1, Bits.long6(x));
        bb._put(bi + 2, Bits.long5(x));
        bb._put(bi + 3, Bits.long4(x));
        bb._put(bi + 4, Bits.long3(x));
        bb._put(bi + 5, Bits.long2(x));
        bb._put(bi + 6, Bits.long1(x));
        bb._put(bi + 7, Bits.long0(x));
    }

    static void putLongB(long a, long x) {
        Bits._put(a, Bits.long7(x));
        Bits._put(a + 1L, Bits.long6(x));
        Bits._put(a + 2L, Bits.long5(x));
        Bits._put(a + 3L, Bits.long4(x));
        Bits._put(a + 4L, Bits.long3(x));
        Bits._put(a + 5L, Bits.long2(x));
        Bits._put(a + 6L, Bits.long1(x));
        Bits._put(a + 7L, Bits.long0(x));
    }

    static void putLong(ByteBuffer bb, int bi, long x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putLongB(bb, bi, x);
        } else {
            Bits.putLongL(bb, bi, x);
        }
    }

    static void putLong(long a, long x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putLongB(a, x);
        } else {
            Bits.putLongL(a, x);
        }
    }

    static float getFloatL(ByteBuffer bb, int bi) {
        return Float.intBitsToFloat(Bits.getIntL(bb, bi));
    }

    static float getFloatL(long a) {
        return Float.intBitsToFloat(Bits.getIntL(a));
    }

    static float getFloatB(ByteBuffer bb, int bi) {
        return Float.intBitsToFloat(Bits.getIntB(bb, bi));
    }

    static float getFloatB(long a) {
        return Float.intBitsToFloat(Bits.getIntB(a));
    }

    static float getFloat(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getFloatB(bb, bi) : Bits.getFloatL(bb, bi);
    }

    static float getFloat(long a, boolean bigEndian) {
        return bigEndian ? Bits.getFloatB(a) : Bits.getFloatL(a);
    }

    static void putFloatL(ByteBuffer bb, int bi, float x) {
        Bits.putIntL(bb, bi, Float.floatToRawIntBits(x));
    }

    static void putFloatL(long a, float x) {
        Bits.putIntL(a, Float.floatToRawIntBits(x));
    }

    static void putFloatB(ByteBuffer bb, int bi, float x) {
        Bits.putIntB(bb, bi, Float.floatToRawIntBits(x));
    }

    static void putFloatB(long a, float x) {
        Bits.putIntB(a, Float.floatToRawIntBits(x));
    }

    static void putFloat(ByteBuffer bb, int bi, float x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putFloatB(bb, bi, x);
        } else {
            Bits.putFloatL(bb, bi, x);
        }
    }

    static void putFloat(long a, float x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putFloatB(a, x);
        } else {
            Bits.putFloatL(a, x);
        }
    }

    static double getDoubleL(ByteBuffer bb, int bi) {
        return Double.longBitsToDouble(Bits.getLongL(bb, bi));
    }

    static double getDoubleL(long a) {
        return Double.longBitsToDouble(Bits.getLongL(a));
    }

    static double getDoubleB(ByteBuffer bb, int bi) {
        return Double.longBitsToDouble(Bits.getLongB(bb, bi));
    }

    static double getDoubleB(long a) {
        return Double.longBitsToDouble(Bits.getLongB(a));
    }

    static double getDouble(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getDoubleB(bb, bi) : Bits.getDoubleL(bb, bi);
    }

    static double getDouble(long a, boolean bigEndian) {
        return bigEndian ? Bits.getDoubleB(a) : Bits.getDoubleL(a);
    }

    static void putDoubleL(ByteBuffer bb, int bi, double x) {
        Bits.putLongL(bb, bi, Double.doubleToRawLongBits(x));
    }

    static void putDoubleL(long a, double x) {
        Bits.putLongL(a, Double.doubleToRawLongBits(x));
    }

    static void putDoubleB(ByteBuffer bb, int bi, double x) {
        Bits.putLongB(bb, bi, Double.doubleToRawLongBits(x));
    }

    static void putDoubleB(long a, double x) {
        Bits.putLongB(a, Double.doubleToRawLongBits(x));
    }

    static void putDouble(ByteBuffer bb, int bi, double x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putDoubleB(bb, bi, x);
        } else {
            Bits.putDoubleL(bb, bi, x);
        }
    }

    static void putDouble(long a, double x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putDoubleB(a, x);
        } else {
            Bits.putDoubleL(a, x);
        }
    }

    private static byte _get(long a) {
        return unsafe.getByte(a);
    }

    private static void _put(long a, byte b) {
        unsafe.putByte(a, b);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static ByteOrder byteOrder() {
        return byteOrder;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Bits.unsafe().pageSize();
        }
        return pageSize;
    }

    static int pageCount(long size) {
        return (int)(size + (long)Bits.pageSize() - 1L) / Bits.pageSize();
    }

    static boolean unaligned() {
        return unaligned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reserveMemory(long size, int cap) {
        Class<Bits> clazz = Bits.class;
        synchronized (Bits.class) {
            if (!memoryLimitSet && VM.isBooted()) {
                maxMemory = VM.maxDirectMemory();
                memoryLimitSet = true;
            }
            if ((long)cap <= maxMemory - totalCapacity) {
                reservedMemory += size;
                totalCapacity += (long)cap;
                ++count;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
            clazz = Bits.class;
            synchronized (Bits.class) {
                if (totalCapacity + (long)cap > maxMemory) {
                    throw new OutOfMemoryError("Direct buffer memory");
                }
                reservedMemory += size;
                totalCapacity += (long)cap;
                ++count;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }
    }

    static synchronized void unreserveMemory(long size, int cap) {
        if (reservedMemory > 0L) {
            totalCapacity -= (long)cap;
            --count;
            assert ((reservedMemory -= size) > -1L);
        }
    }

    static void copyFromArray(Object src, long srcBaseOffset, long srcPos, long dstAddr, long length) {
        long offset = srcBaseOffset + srcPos;
        while (length > 0L) {
            long size = length > 0x100000L ? 0x100000L : length;
            unsafe.copyMemory(src, offset, null, dstAddr, size);
            length -= size;
            offset += size;
            dstAddr += size;
        }
    }

    static void copyToArray(long srcAddr, Object dst, long dstBaseOffset, long dstPos, long length) {
        long offset = dstBaseOffset + dstPos;
        while (length > 0L) {
            long size = length > 0x100000L ? 0x100000L : length;
            unsafe.copyMemory(null, srcAddr, dst, offset, size);
            length -= size;
            srcAddr += size;
            offset += size;
        }
    }

    static void copyFromCharArray(Object src, long srcPos, long dstAddr, long length) {
        unsafe.copySwapMemory(src, (long)unsafe.arrayBaseOffset(src.getClass()) + srcPos, null, dstAddr, length, 2L);
    }

    static void copyToCharArray(long srcAddr, Object dst, long dstPos, long length) {
        unsafe.copySwapMemory(null, srcAddr, dst, (long)unsafe.arrayBaseOffset(dst.getClass()) + dstPos, length, 2L);
    }

    static void copyFromShortArray(Object src, long srcPos, long dstAddr, long length) {
        unsafe.copySwapMemory(src, (long)unsafe.arrayBaseOffset(src.getClass()) + srcPos, null, dstAddr, length, 2L);
    }

    static void copyToShortArray(long srcAddr, Object dst, long dstPos, long length) {
        unsafe.copySwapMemory(null, srcAddr, dst, (long)unsafe.arrayBaseOffset(dst.getClass()) + dstPos, length, 2L);
    }

    static void copyFromIntArray(Object src, long srcPos, long dstAddr, long length) {
        unsafe.copySwapMemory(src, (long)unsafe.arrayBaseOffset(src.getClass()) + srcPos, null, dstAddr, length, 4L);
    }

    static void copyToIntArray(long srcAddr, Object dst, long dstPos, long length) {
        unsafe.copySwapMemory(null, srcAddr, dst, (long)unsafe.arrayBaseOffset(dst.getClass()) + dstPos, length, 4L);
    }

    static void copyFromLongArray(Object src, long srcPos, long dstAddr, long length) {
        unsafe.copySwapMemory(src, (long)unsafe.arrayBaseOffset(src.getClass()) + srcPos, null, dstAddr, length, 8L);
    }

    static void copyToLongArray(long srcAddr, Object dst, long dstPos, long length) {
        unsafe.copySwapMemory(null, srcAddr, dst, (long)unsafe.arrayBaseOffset(dst.getClass()) + dstPos, length, 8L);
    }

    static {
        memoryLimitSet = false;
        SharedSecrets.setJavaNioAccess(new JavaNioAccess(){

            @Override
            public JavaNioAccess.BufferPool getDirectBufferPool() {
                return new JavaNioAccess.BufferPool(){

                    @Override
                    public String getName() {
                        return "direct";
                    }

                    @Override
                    public long getCount() {
                        return count;
                    }

                    @Override
                    public long getTotalCapacity() {
                        return totalCapacity;
                    }

                    @Override
                    public long getMemoryUsed() {
                        return reservedMemory;
                    }
                };
            }

            @Override
            public ByteBuffer newDirectByteBuffer(long addr, int cap, Object ob) {
                return new DirectByteBuffer(addr, cap, ob);
            }

            @Override
            public void truncate(Buffer buf) {
                buf.truncate();
            }
        });
    }
}

