/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.MidiInDevice;
import com.sun.media.sound.Platform;
import javax.sound.midi.MidiDevice;

public final class MidiInDeviceProvider
extends AbstractMidiDeviceProvider {
    private static AbstractMidiDeviceProvider.Info[] infos = null;
    private static MidiDevice[] devices = null;
    private static final boolean enabled;

    @Override
    AbstractMidiDeviceProvider.Info createInfo(int index) {
        if (!enabled) {
            return null;
        }
        return new MidiInDeviceInfo(index, MidiInDeviceProvider.class);
    }

    @Override
    MidiDevice createDevice(AbstractMidiDeviceProvider.Info info) {
        if (enabled && info instanceof MidiInDeviceInfo) {
            return new MidiInDevice(info);
        }
        return null;
    }

    @Override
    int getNumDevices() {
        if (!enabled) {
            return 0;
        }
        int numDevices = MidiInDeviceProvider.nGetNumDevices();
        return numDevices;
    }

    @Override
    MidiDevice[] getDeviceCache() {
        return devices;
    }

    @Override
    void setDeviceCache(MidiDevice[] devices) {
        MidiInDeviceProvider.devices = devices;
    }

    @Override
    AbstractMidiDeviceProvider.Info[] getInfoCache() {
        return infos;
    }

    @Override
    void setInfoCache(AbstractMidiDeviceProvider.Info[] infos) {
        MidiInDeviceProvider.infos = infos;
    }

    private static native int nGetNumDevices();

    private static native String nGetName(int var0);

    private static native String nGetVendor(int var0);

    private static native String nGetDescription(int var0);

    private static native String nGetVersion(int var0);

    static {
        Platform.initialize();
        enabled = Platform.isMidiIOEnabled();
    }

    static final class MidiInDeviceInfo
    extends AbstractMidiDeviceProvider.Info {
        private final Class providerClass;

        private MidiInDeviceInfo(int index, Class providerClass) {
            super(MidiInDeviceProvider.nGetName(index), MidiInDeviceProvider.nGetVendor(index), MidiInDeviceProvider.nGetDescription(index), MidiInDeviceProvider.nGetVersion(index), index);
            this.providerClass = providerClass;
        }
    }
}

