/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.Painter;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import javax.swing.plaf.nimbus.State;
import javax.swing.plaf.nimbus.SynthPainterImpl;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public final class NimbusStyle
extends SynthStyle {
    public static final String LARGE_KEY = "large";
    public static final String SMALL_KEY = "small";
    public static final String MINI_KEY = "mini";
    public static final double LARGE_SCALE = 1.15;
    public static final double SMALL_SCALE = 0.857;
    public static final double MINI_SCALE = 0.714;
    private static final Object NULL = Character.valueOf('\u0000');
    private static final Color DEFAULT_COLOR = new ColorUIResource(Color.BLACK);
    private static final Comparator<RuntimeState> STATE_COMPARATOR = new Comparator<RuntimeState>(){

        @Override
        public int compare(RuntimeState a, RuntimeState b) {
            return a.state - b.state;
        }
    };
    private String prefix;
    private SynthPainter painter;
    private Values values;
    private CacheKey tmpKey = new CacheKey("", 0);
    private WeakReference<JComponent> component;

    NimbusStyle(String prefix, JComponent c) {
        if (c != null) {
            this.component = new WeakReference<JComponent>(c);
        }
        this.prefix = prefix;
        this.painter = new SynthPainterImpl(this);
    }

    @Override
    public void installDefaults(SynthContext ctx) {
        this.validate();
        super.installDefaults(ctx);
    }

    private void validate() {
        Object o;
        if (this.values != null) {
            return;
        }
        this.values = new Values();
        Map<String, Object> defaults = ((NimbusLookAndFeel)UIManager.getLookAndFeel()).getDefaultsForPrefix(this.prefix);
        if (this.component != null && (o = ((JComponent)this.component.get()).getClientProperty("Nimbus.Overrides")) instanceof UIDefaults) {
            Object i = ((JComponent)this.component.get()).getClientProperty("Nimbus.Overrides.InheritDefaults");
            boolean inherit = i instanceof Boolean ? (Boolean)i : true;
            UIDefaults d = (UIDefaults)o;
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (Object obj : d.keySet()) {
                String key;
                if (!(obj instanceof String) || !(key = (String)obj).startsWith(this.prefix)) continue;
                map.put(key, d.get(key));
            }
            if (inherit) {
                defaults.putAll(map);
            } else {
                defaults = map;
            }
        }
        ArrayList<State> states = new ArrayList<State>();
        HashMap<String, Integer> stateCodes = new HashMap<String, Integer>();
        ArrayList<RuntimeState> runtimeStates = new ArrayList<RuntimeState>();
        String statesString = (String)defaults.get(this.prefix + ".States");
        if (statesString != null) {
            String[] s = statesString.split(",");
            for (int i = 0; i < s.length; ++i) {
                s[i] = s[i].trim();
                if (!State.isStandardStateName(s[i])) {
                    String stateName = this.prefix + "." + s[i];
                    State customState = (State)defaults.get(stateName);
                    if (customState == null) continue;
                    states.add(customState);
                    continue;
                }
                states.add(State.getStandardState(s[i]));
            }
            if (states.size() > 0) {
                this.values.stateTypes = states.toArray(new State[states.size()]);
            }
            int code = 1;
            for (State state : states) {
                stateCodes.put(state.getName(), code);
                code <<= 1;
            }
        } else {
            states.add(State.Enabled);
            states.add(State.MouseOver);
            states.add(State.Pressed);
            states.add(State.Disabled);
            states.add(State.Focused);
            states.add(State.Selected);
            states.add(State.Default);
            stateCodes.put("Enabled", 1);
            stateCodes.put("MouseOver", 2);
            stateCodes.put("Pressed", 4);
            stateCodes.put("Disabled", 8);
            stateCodes.put("Focused", 256);
            stateCodes.put("Selected", 512);
            stateCodes.put("Default", 1024);
        }
        for (String key : defaults.keySet()) {
            String[] stateParts;
            String temp = key.substring(this.prefix.length());
            if (temp.indexOf(34) != -1 || temp.indexOf(58) != -1) continue;
            temp = temp.substring(1);
            String stateString = null;
            String property = null;
            int bracketIndex = temp.indexOf(93);
            if (bracketIndex < 0) {
                property = temp;
            } else {
                stateString = temp.substring(0, bracketIndex);
                property = temp.substring(bracketIndex + 2);
            }
            if (stateString == null) {
                if ("contentMargins".equals(property)) {
                    this.values.contentMargins = (Insets)defaults.get(key);
                    continue;
                }
                if ("States".equals(property)) continue;
                this.values.defaults.put(property, defaults.get(key));
                continue;
            }
            boolean skip = false;
            int componentState = 0;
            for (String s : stateParts = stateString.split("\\+")) {
                if (stateCodes.containsKey(s)) {
                    componentState |= ((Integer)stateCodes.get(s)).intValue();
                    continue;
                }
                skip = true;
                break;
            }
            if (skip) continue;
            RuntimeState rs = null;
            for (RuntimeState s : runtimeStates) {
                if (s.state != componentState) continue;
                rs = s;
                break;
            }
            if (rs == null) {
                rs = new RuntimeState(componentState, stateString);
                runtimeStates.add(rs);
            }
            if ("backgroundPainter".equals(property)) {
                rs.backgroundPainter = this.getPainter(defaults, key);
                continue;
            }
            if ("foregroundPainter".equals(property)) {
                rs.foregroundPainter = this.getPainter(defaults, key);
                continue;
            }
            if ("borderPainter".equals(property)) {
                rs.borderPainter = this.getPainter(defaults, key);
                continue;
            }
            rs.defaults.put(property, defaults.get(key));
        }
        Collections.sort(runtimeStates, STATE_COMPARATOR);
        this.values.states = runtimeStates.toArray(new RuntimeState[runtimeStates.size()]);
    }

    private Painter getPainter(Map<String, Object> defaults, String key) {
        Object p = defaults.get(key);
        if (p instanceof UIDefaults.LazyValue) {
            p = ((UIDefaults.LazyValue)p).createValue(UIManager.getDefaults());
        }
        return p instanceof Painter ? (Painter)p : null;
    }

    @Override
    public Insets getInsets(SynthContext ctx, Insets in) {
        if (in == null) {
            in = new Insets(0, 0, 0, 0);
        }
        Values v = this.getValues(ctx);
        if (v.contentMargins == null) {
            in.right = 0;
            in.left = 0;
            in.top = 0;
            in.bottom = 0;
            return in;
        }
        in.bottom = v.contentMargins.bottom;
        in.top = v.contentMargins.top;
        in.left = v.contentMargins.left;
        in.right = v.contentMargins.right;
        String scaleKey = (String)ctx.getComponent().getClientProperty("JComponent.sizeVariant");
        if (scaleKey != null) {
            if (LARGE_KEY.equals(scaleKey)) {
                in.bottom = (int)((double)in.bottom * 1.15);
                in.top = (int)((double)in.top * 1.15);
                in.left = (int)((double)in.left * 1.15);
                in.right = (int)((double)in.right * 1.15);
            } else if (SMALL_KEY.equals(scaleKey)) {
                in.bottom = (int)((double)in.bottom * 0.857);
                in.top = (int)((double)in.top * 0.857);
                in.left = (int)((double)in.left * 0.857);
                in.right = (int)((double)in.right * 0.857);
            } else if (MINI_KEY.equals(scaleKey)) {
                in.bottom = (int)((double)in.bottom * 0.714);
                in.top = (int)((double)in.top * 0.714);
                in.left = (int)((double)in.left * 0.714);
                in.right = (int)((double)in.right * 0.714);
            }
        }
        return in;
    }

    @Override
    protected Color getColorForState(SynthContext ctx, ColorType type) {
        String key = null;
        if (type == ColorType.BACKGROUND) {
            key = "background";
        } else if (type == ColorType.FOREGROUND) {
            key = "textForeground";
        } else if (type == ColorType.TEXT_BACKGROUND) {
            key = "textBackground";
        } else if (type == ColorType.TEXT_FOREGROUND) {
            key = "textForeground";
        } else if (type == ColorType.FOCUS) {
            key = "focus";
        } else if (type != null) {
            key = type.toString();
        } else {
            return DEFAULT_COLOR;
        }
        Color c = (Color)this.get(ctx, key);
        if (c == null) {
            c = DEFAULT_COLOR;
        }
        return c;
    }

    @Override
    protected Font getFontForState(SynthContext ctx) {
        String scaleKey;
        Font f = (Font)this.get(ctx, "font");
        if (f == null) {
            f = UIManager.getFont("defaultFont");
        }
        if ((scaleKey = (String)ctx.getComponent().getClientProperty("JComponent.sizeVariant")) != null) {
            if (LARGE_KEY.equals(scaleKey)) {
                f = f.deriveFont(Math.round((double)f.getSize2D() * 1.15));
            } else if (SMALL_KEY.equals(scaleKey)) {
                f = f.deriveFont(Math.round((double)f.getSize2D() * 0.857));
            } else if (MINI_KEY.equals(scaleKey)) {
                f = f.deriveFont(Math.round((double)f.getSize2D() * 0.714));
            }
        }
        return f;
    }

    @Override
    public SynthPainter getPainter(SynthContext ctx) {
        return this.painter;
    }

    @Override
    public boolean isOpaque(SynthContext ctx) {
        if ("Table.cellRenderer".equals(ctx.getComponent().getName())) {
            return true;
        }
        Boolean opaque = (Boolean)this.get(ctx, "opaque");
        return opaque == null ? false : opaque;
    }

    @Override
    public Object get(SynthContext ctx, Object key) {
        boolean wasInCache;
        Values v = this.getValues(ctx);
        String fullKey = key.toString();
        String partialKey = fullKey.substring(fullKey.indexOf(".") + 1);
        Object obj = null;
        int xstate = this.getExtendedState(ctx, v);
        this.tmpKey.init(partialKey, xstate);
        obj = v.cache.get(this.tmpKey);
        boolean bl = wasInCache = obj != null;
        if (!wasInCache) {
            RuntimeState s = null;
            int[] lastIndex = new int[]{-1};
            while (obj == null && (s = this.getNextState(v.states, lastIndex, xstate)) != null) {
                obj = s.defaults.get(partialKey);
            }
            if (obj == null && v.defaults != null) {
                obj = v.defaults.get(partialKey);
            }
            if (obj == null) {
                obj = UIManager.get(fullKey);
            }
            if (obj == null && partialKey.equals("focusInputMap")) {
                obj = super.get(ctx, fullKey);
            }
            v.cache.put(new CacheKey(partialKey, xstate), obj == null ? NULL : obj);
        }
        return obj == NULL ? null : obj;
    }

    public Painter getBackgroundPainter(SynthContext ctx) {
        Values v = this.getValues(ctx);
        int xstate = this.getExtendedState(ctx, v);
        Painter p = null;
        this.tmpKey.init("backgroundPainter$$instance", xstate);
        p = (Painter)v.cache.get(this.tmpKey);
        if (p != null) {
            return p;
        }
        RuntimeState s = null;
        int[] lastIndex = new int[]{-1};
        while ((s = this.getNextState(v.states, lastIndex, xstate)) != null) {
            if (s.backgroundPainter == null) continue;
            p = s.backgroundPainter;
            break;
        }
        if (p == null) {
            p = (Painter)this.get(ctx, "backgroundPainter");
        }
        if (p != null) {
            v.cache.put(new CacheKey("backgroundPainter$$instance", xstate), p);
        }
        return p;
    }

    public Painter getForegroundPainter(SynthContext ctx) {
        Values v = this.getValues(ctx);
        int xstate = this.getExtendedState(ctx, v);
        Painter p = null;
        this.tmpKey.init("foregroundPainter$$instance", xstate);
        p = (Painter)v.cache.get(this.tmpKey);
        if (p != null) {
            return p;
        }
        RuntimeState s = null;
        int[] lastIndex = new int[]{-1};
        while ((s = this.getNextState(v.states, lastIndex, xstate)) != null) {
            if (s.foregroundPainter == null) continue;
            p = s.foregroundPainter;
            break;
        }
        if (p == null) {
            p = (Painter)this.get(ctx, "foregroundPainter");
        }
        if (p != null) {
            v.cache.put(new CacheKey("foregroundPainter$$instance", xstate), p);
        }
        return p;
    }

    public Painter getBorderPainter(SynthContext ctx) {
        Values v = this.getValues(ctx);
        int xstate = this.getExtendedState(ctx, v);
        Painter p = null;
        this.tmpKey.init("borderPainter$$instance", xstate);
        p = (Painter)v.cache.get(this.tmpKey);
        if (p != null) {
            return p;
        }
        RuntimeState s = null;
        int[] lastIndex = new int[]{-1};
        while ((s = this.getNextState(v.states, lastIndex, xstate)) != null) {
            if (s.borderPainter == null) continue;
            p = s.borderPainter;
            break;
        }
        if (p == null) {
            p = (Painter)this.get(ctx, "borderPainter");
        }
        if (p != null) {
            v.cache.put(new CacheKey("borderPainter$$instance", xstate), p);
        }
        return p;
    }

    private Values getValues(SynthContext ctx) {
        this.validate();
        return this.values;
    }

    private boolean contains(String[] names, String name) {
        assert (name != null);
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return true;
        }
        return false;
    }

    private int getExtendedState(SynthContext ctx, Values v) {
        JComponent c = ctx.getComponent();
        int xstate = 0;
        int mask = 1;
        Object property = c.getClientProperty("Nimbus.State");
        if (property != null) {
            String stateNames = property.toString();
            String[] states = stateNames.split("\\+");
            if (v.stateTypes == null) {
                for (String stateStr : states) {
                    State.StandardState s = State.getStandardState(stateStr);
                    if (s == null) continue;
                    xstate |= s.getState();
                }
            } else {
                for (State s : v.stateTypes) {
                    if (this.contains(states, s.getName())) {
                        xstate |= mask;
                    }
                    mask <<= 1;
                }
            }
        } else {
            if (v.stateTypes == null) {
                return ctx.getComponentState();
            }
            int state = ctx.getComponentState();
            for (State s : v.stateTypes) {
                if (s.isInState(c, state)) {
                    xstate |= mask;
                }
                mask <<= 1;
            }
        }
        return xstate;
    }

    private RuntimeState getNextState(RuntimeState[] states, int[] lastState, int xstate) {
        if (states != null && states.length > 0) {
            int bestCount = 0;
            int bestIndex = -1;
            int wildIndex = -1;
            if (xstate == 0) {
                for (int counter = states.length - 1; counter >= 0; --counter) {
                    if (states[counter].state != 0) continue;
                    lastState[0] = counter;
                    return states[counter];
                }
                lastState[0] = -1;
                return null;
            }
            int lastStateIndex = lastState == null || lastState[0] == -1 ? states.length : lastState[0];
            for (int counter = lastStateIndex - 1; counter >= 0; --counter) {
                int oState = states[counter].state;
                if (oState == 0) {
                    if (wildIndex != -1) continue;
                    wildIndex = counter;
                    continue;
                }
                if ((xstate & oState) != oState) continue;
                int bitCount = oState;
                bitCount -= (0xAAAAAAAA & bitCount) >>> 1;
                bitCount = (bitCount & 0x33333333) + (bitCount >>> 2 & 0x33333333);
                bitCount = bitCount + (bitCount >>> 4) & 0xF0F0F0F;
                bitCount += bitCount >>> 8;
                bitCount += bitCount >>> 16;
                if ((bitCount &= 0xFF) <= bestCount) continue;
                bestIndex = counter;
                bestCount = bitCount;
            }
            if (bestIndex != -1) {
                lastState[0] = bestIndex;
                return states[bestIndex];
            }
            if (wildIndex != -1) {
                lastState[0] = wildIndex;
                return states[wildIndex];
            }
        }
        lastState[0] = -1;
        return null;
    }

    private static final class CacheKey {
        private String key;
        private int xstate;

        CacheKey(Object key, int xstate) {
            this.init(key, xstate);
        }

        void init(Object key, int xstate) {
            this.key = key.toString();
            this.xstate = xstate;
        }

        public boolean equals(Object obj) {
            CacheKey other = (CacheKey)obj;
            if (obj == null) {
                return false;
            }
            if (this.xstate != other.xstate) {
                return false;
            }
            return this.key.equals(other.key);
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + this.key.hashCode();
            hash = 29 * hash + this.xstate;
            return hash;
        }
    }

    private static final class Values {
        State[] stateTypes = null;
        RuntimeState[] states = null;
        Insets contentMargins;
        UIDefaults defaults = new UIDefaults(10, 0.7f);
        Map<CacheKey, Object> cache = new HashMap<CacheKey, Object>();

        private Values() {
        }
    }

    private final class RuntimeState
    implements Cloneable {
        int state;
        Painter backgroundPainter;
        Painter foregroundPainter;
        Painter borderPainter;
        String stateName;
        UIDefaults defaults = new UIDefaults(10, 0.7f);

        private RuntimeState(int state, String stateName) {
            this.state = state;
            this.stateName = stateName;
        }

        public String toString() {
            return this.stateName;
        }

        public RuntimeState clone() {
            RuntimeState clone = new RuntimeState(this.state, this.stateName);
            clone.backgroundPainter = this.backgroundPainter;
            clone.foregroundPainter = this.foregroundPainter;
            clone.borderPainter = this.borderPainter;
            clone.defaults.putAll(this.defaults);
            return clone;
        }
    }
}

