/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pisces.PiscesCache;
import sun.java2d.pisces.Renderer;

final class PiscesTileGenerator
implements AATileGenerator {
    public static final int TILE_SIZE = 32;
    private static final Map<Integer, byte[]> alphaMapsCache = new ConcurrentHashMap<Integer, byte[]>();
    PiscesCache cache;
    int x;
    int y;
    final int maxalpha;
    private final int maxTileAlphaSum;
    byte[] alphaMap;

    public PiscesTileGenerator(Renderer r, int maxalpha) {
        this.cache = r.getCache();
        this.x = this.cache.bboxX0;
        this.y = this.cache.bboxY0;
        this.alphaMap = PiscesTileGenerator.getAlphaMap(maxalpha);
        this.maxalpha = maxalpha;
        this.maxTileAlphaSum = 1024 * maxalpha;
    }

    private static byte[] buildAlphaMap(int maxalpha) {
        byte[] alMap = new byte[maxalpha + 1];
        int halfmaxalpha = maxalpha >> 2;
        for (int i = 0; i <= maxalpha; ++i) {
            alMap[i] = (byte)((i * 255 + halfmaxalpha) / maxalpha);
        }
        return alMap;
    }

    public static byte[] getAlphaMap(int maxalpha) {
        if (!alphaMapsCache.containsKey(maxalpha)) {
            alphaMapsCache.put(maxalpha, PiscesTileGenerator.buildAlphaMap(maxalpha));
        }
        return alphaMapsCache.get(maxalpha);
    }

    public void getBbox(int[] bbox) {
        bbox[0] = this.cache.bboxX0;
        bbox[1] = this.cache.bboxY0;
        bbox[2] = this.cache.bboxX1;
        bbox[3] = this.cache.bboxY1;
    }

    @Override
    public int getTileWidth() {
        return 32;
    }

    @Override
    public int getTileHeight() {
        return 32;
    }

    @Override
    public int getTypicalAlpha() {
        int al = this.cache.alphaSumInTile(this.x, this.y);
        return al == 0 ? 0 : (al == this.maxTileAlphaSum ? 255 : 128);
    }

    @Override
    public void nextTile() {
        if ((this.x += 32) >= this.cache.bboxX1) {
            this.x = this.cache.bboxX0;
            this.y += 32;
        }
    }

    @Override
    public void getAlpha(byte[] tile, int offset, int rowstride) {
        int x0 = this.x;
        int x1 = x0 + 32;
        int y0 = this.y;
        int y1 = y0 + 32;
        if (x1 > this.cache.bboxX1) {
            x1 = this.cache.bboxX1;
        }
        if (y1 > this.cache.bboxY1) {
            y1 = this.cache.bboxY1;
        }
        y1 -= this.cache.bboxY0;
        int idx = offset;
        for (int cy = y0 -= this.cache.bboxY0; cy < y1; ++cy) {
            int[] row = this.cache.rowAARLE[cy];
            assert (row != null);
            int cx = this.cache.minTouched(cy);
            if (cx > x1) {
                cx = x1;
            }
            for (int i = x0; i < cx; ++i) {
                tile[idx++] = 0;
            }
            for (int pos = 2; cx < x1 && pos < row[1]; pos += 2) {
                byte val;
                int runLen = 0;
                assert (row[1] > 2);
                try {
                    val = this.alphaMap[row[pos]];
                    runLen = row[pos + 1];
                    assert (runLen > 0);
                }
                catch (RuntimeException e0) {
                    System.out.println("maxalpha = " + this.maxalpha);
                    System.out.println("tile[" + x0 + ", " + y0 + " => " + x1 + ", " + y1 + "]");
                    System.out.println("cx = " + cx + ", cy = " + cy);
                    System.out.println("idx = " + idx + ", pos = " + pos);
                    System.out.println("len = " + runLen);
                    System.out.print(this.cache.toString());
                    e0.printStackTrace();
                    throw e0;
                }
                int rx0 = cx;
                int rx1 = cx += runLen;
                if (rx0 < x0) {
                    rx0 = x0;
                }
                if (rx1 > x1) {
                    rx1 = x1;
                }
                runLen = rx1 - rx0;
                while (--runLen >= 0) {
                    try {
                        tile[idx++] = val;
                    }
                    catch (RuntimeException e) {
                        System.out.println("maxalpha = " + this.maxalpha);
                        System.out.println("tile[" + x0 + ", " + y0 + " => " + x1 + ", " + y1 + "]");
                        System.out.println("cx = " + cx + ", cy = " + cy);
                        System.out.println("idx = " + idx + ", pos = " + pos);
                        System.out.println("rx0 = " + rx0 + ", rx1 = " + rx1);
                        System.out.println("len = " + runLen);
                        System.out.print(this.cache.toString());
                        e.printStackTrace();
                        throw e;
                    }
                }
            }
            if (cx < x0) {
                cx = x0;
            }
            while (cx < x1) {
                tile[idx++] = 0;
                ++cx;
            }
            idx += rowstride - (x1 - x0);
        }
        this.nextTile();
    }

    static String hex(int v, int d) {
        String s = Integer.toHexString(v);
        while (s.length() < d) {
            s = "0" + s;
        }
        return s.substring(0, d);
    }

    @Override
    public void dispose() {
    }
}

